/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.jcajce.symmetric;

import cfca.sadk.algorithm.sm2.SM4Engine;
import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.DataLengthException;
import cfca.sadk.org.bouncycastle.crypto.InvalidCipherTextException;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.BlockCipherPadding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.util.Base64;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;

public class SM4Cipher
extends CipherSpi {
    private byte[] IV;
    private byte[] key;
    private boolean forEncryption;
    private String Padding;
    private BlockCipher cipherMode;
    private BlockCipherPadding padding;
    private BlockCipher cipherEngine = new SM4Engine();
    private int blockSize;
    private PaddedBufferedBlockCipher cipherSM4;
    private int outputSize;
    private String Mode;

    public SM4Cipher() {
        this.cipherMode = new CBCBlockCipher(this.cipherEngine);
        this.padding = new PKCS7Padding();
        this.cipherSM4 = new PaddedBufferedBlockCipher(this.cipherMode, this.padding);
        this.blockSize = this.cipherEngine.getBlockSize();
    }

    protected byte[] engineDoFinal(byte[] data, int off, int len) throws IllegalBlockSizeException, BadPaddingException {
        byte[] outData = null;
        try {
            this.outputSize = this.cipherSM4.getOutputSize(data.length);
            byte[] tempData = new byte[this.outputSize];
            int len1 = this.cipherSM4.processBytes(data, 0, data.length, tempData, 0);
            int len2 = this.cipherSM4.doFinal(tempData, len1);
            int total = len1 + len2;
            if (total < len) {
                byte[] removeZeroSourceData = new byte[total];
                System.arraycopy(tempData, 0, removeZeroSourceData, 0, total);
                outData = removeZeroSourceData;
            } else {
                outData = tempData;
            }
        }
        catch (DataLengthException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (InvalidCipherTextException e) {
            e.printStackTrace();
        }
        return outData;
    }

    protected int engineDoFinal(byte[] arg0, int arg1, int arg2, byte[] arg3, int arg4) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return 0;
    }

    protected int engineGetBlockSize() {
        return this.blockSize;
    }

    protected byte[] engineGetIV() {
        return this.IV;
    }

    protected int engineGetOutputSize(int len) {
        return this.outputSize;
    }

    protected int engineGetKeySize(Key paramKey) throws InvalidKeyException {
        byte[] key = paramKey.getEncoded();
        if (32 != key.length) {
            throw new InvalidKeyException("key must be 32 bytes");
        }
        return 16;
    }

    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    protected void engineInit(int paramInt, Key paramKey, SecureRandom paramSecureRandom) throws InvalidKeyException {
        if (1 == paramInt) {
            this.forEncryption = true;
        } else if (2 == paramInt) {
            this.forEncryption = false;
        }
        SecretKey secretKey = null;
        if (!(paramKey instanceof SecretKey)) {
            throw new InvalidKeyException("paramKey not SecretKey");
        }
        secretKey = (SecretKey)paramKey;
        byte[] keyWithIV = secretKey.getEncoded();
        this.IV = new byte[16];
        this.key = new byte[16];
        System.arraycopy(keyWithIV, 0, this.IV, 0, 16);
        System.arraycopy(keyWithIV, 16, this.key, 0, 16);
        this.padding.init(null);
        ParametersWithIV params = new ParametersWithIV(new KeyParameter(this.key), this.IV);
        this.cipherSM4.init(this.forEncryption, params);
    }

    protected void engineInit(int arg0, Key arg1, AlgorithmParameterSpec arg2, SecureRandom arg3) throws InvalidKeyException, InvalidAlgorithmParameterException {
    }

    protected void engineInit(int arg0, Key arg1, AlgorithmParameters arg2, SecureRandom arg3) throws InvalidKeyException, InvalidAlgorithmParameterException {
    }

    protected void engineSetMode(String Mode) throws NoSuchAlgorithmException {
        this.Mode = Mode;
    }

    protected void engineSetPadding(String Padding) throws NoSuchPaddingException {
        this.Padding = Padding;
    }

    protected byte[] engineUpdate(byte[] arg0, int arg1, int arg2) {
        return null;
    }

    protected int engineUpdate(byte[] arg0, int arg1, int arg2, byte[] arg3, int arg4) throws ShortBufferException {
        return 0;
    }

    public static class SM4CipherinBase64
    extends SM4Cipher {
        protected byte[] engineDoFinal(byte[] data, int off, int len) throws IllegalBlockSizeException, BadPaddingException {
            if (((SM4Cipher)this).forEncryption) {
                return Base64.encode(super.engineDoFinal(data, off, len));
            }
            return super.engineDoFinal(Base64.decode(data), off, len);
        }
    }
}

