/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.generators;

import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import cfca.sadk.org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import cfca.sadk.org.bouncycastle.crypto.KeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.generators.DHKeyGeneratorHelper;
import cfca.sadk.org.bouncycastle.crypto.params.DHParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ElGamalKeyGenerationParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ElGamalParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import cfca.sadk.org.bouncycastle.crypto.params.ElGamalPublicKeyParameters;
import java.math.BigInteger;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

