/*
 * Decompiled with CFR 0.152.
 */
package com.yeepay.shade.com.fasterxml.jackson.databind.jsontype.impl;

import com.yeepay.shade.com.fasterxml.jackson.databind.BeanDescription;
import com.yeepay.shade.com.fasterxml.jackson.databind.DeserializationContext;
import com.yeepay.shade.com.fasterxml.jackson.databind.JavaType;
import com.yeepay.shade.com.fasterxml.jackson.databind.JsonMappingException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SubTypeValidator {
    protected static final String PREFIX_SPRING = "org.springframework.";
    protected static final String PREFIX_C3P0 = "com.mchange.v2.c3p0.";
    protected static final Set<String> DEFAULT_NO_DESER_CLASS_NAMES;
    protected Set<String> _cfgIllegalClassNames = DEFAULT_NO_DESER_CLASS_NAMES;
    private static final SubTypeValidator instance;

    protected SubTypeValidator() {
    }

    public static SubTypeValidator instance() {
        return instance;
    }

    public void validateSubType(DeserializationContext ctxt, JavaType type, BeanDescription beanDesc) throws JsonMappingException {
        String full;
        block6: {
            block7: {
                block8: {
                    Class<?> raw = type.getRawClass();
                    full = raw.getName();
                    if (this._cfgIllegalClassNames.contains(full)) break block6;
                    if (raw.isInterface()) break block7;
                    if (!full.startsWith(PREFIX_SPRING)) break block8;
                    for (Class<?> cls = raw; cls != null && cls != Object.class; cls = cls.getSuperclass()) {
                        String name = cls.getSimpleName();
                        if (!"AbstractPointcutAdvisor".equals(name) && !"AbstractApplicationContext".equals(name)) {
                            continue;
                        }
                        break block6;
                    }
                    break block7;
                }
                if (full.startsWith(PREFIX_C3P0) && full.endsWith("DataSource")) break block6;
            }
            return;
        }
        ctxt.reportBadTypeDefinition(beanDesc, "Illegal type (%s) to deserialize: prevented for security reasons", full);
    }

    static {
        HashSet<String> s = new HashSet<String>();
        s.add("com.yeepay.shade.org.apache.commons.collections.functors.InvokerTransformer");
        s.add("com.yeepay.shade.org.apache.commons.collections.functors.InstantiateTransformer");
        s.add("com.yeepay.shade.org.apache.commons.collections4.functors.InvokerTransformer");
        s.add("com.yeepay.shade.org.apache.commons.collections4.functors.InstantiateTransformer");
        s.add("com.yeepay.shade.org.codehaus.groovy.runtime.ConvertedClosure");
        s.add("com.yeepay.shade.org.codehaus.groovy.runtime.MethodClosure");
        s.add("org.springframework.beans.factory.ObjectFactory");
        s.add("com.sun.org.apache.xalan.internal.xsltc.trax.TemplatesImpl");
        s.add("com.yeepay.shade.org.apache.xalan.xsltc.trax.TemplatesImpl");
        s.add("com.sun.rowset.JdbcRowSetImpl");
        s.add("java.util.logging.FileHandler");
        s.add("java.rmi.server.UnicastRemoteObject");
        s.add("org.springframework.beans.factory.config.PropertyPathFactoryBean");
        s.add("com.yeepay.shade.org.apache.tomcat.dbcp.dbcp2.BasicDataSource");
        s.add("com.sun.org.apache.bcel.internal.util.ClassLoader");
        s.add("org.hibernate.jmx.StatisticsService");
        s.add("com.yeepay.shade.org.apache.ibatis.datasource.jndi.JndiDataSourceFactory");
        s.add("com.yeepay.shade.org.apache.ibatis.parsing.XPathParser");
        s.add("jodd.db.connection.DataSourceConnectionProvider");
        s.add("oracle.jdbc.connector.OracleManagedConnectionFactory");
        s.add("oracle.jdbc.rowset.OracleJDBCRowSet");
        s.add("org.slf4j.ext.EventData");
        s.add("flex.messaging.util.concurrent.AsynchBeansWorkManagerExecutor");
        s.add("com.sun.deploy.security.ruleset.DRSHelper");
        s.add("com.yeepay.shade.org.apache.axis2.jaxws.spi.handler.HandlerResolverImpl");
        s.add("org.jboss.util.propertyeditor.DocumentEditor");
        s.add("com.yeepay.shade.org.apache.openjpa.ee.RegistryManagedRuntime");
        s.add("com.yeepay.shade.org.apache.openjpa.ee.JNDIManagedRuntime");
        s.add("com.yeepay.shade.org.apache.axis2.transport.jms.JMSOutTransportInfo");
        s.add("com.mysql.cj.jdbc.admin.MiniAdmin");
        s.add("ch.qos.logback.core.db.DriverManagerConnectionSource");
        s.add("org.jdom.transform.XSLTransformer");
        s.add("org.jdom2.transform.XSLTransformer");
        s.add("net.sf.ehcache.transaction.manager.DefaultTransactionManagerLookup");
        s.add("net.sf.ehcache.hibernate.EhcacheJtaTransactionManagerLookup");
        s.add("ch.qos.logback.core.db.JNDIConnectionSource");
        s.add("com.zaxxer.hikari.HikariConfig");
        s.add("com.zaxxer.hikari.HikariDataSource");
        s.add("com.yeepay.shade.org.apache.cxf.jaxrs.provider.XSLTJaxbProvider");
        s.add("com.yeepay.shade.org.apache.commons.configuration.JNDIConfiguration");
        s.add("com.yeepay.shade.org.apache.commons.configuration2.JNDIConfiguration");
        s.add("com.yeepay.shade.org.apache.xalan.lib.sql.JNDIConnectionPool");
        s.add("com.yeepay.shade.org.apache.commons.dbcp.datasources.PerUserPoolDataSource");
        s.add("com.yeepay.shade.org.apache.commons.dbcp.datasources.SharedPoolDataSource");
        s.add("com.p6spy.engine.spy.P6DataSource");
        s.add("com.yeepay.shade.org.apache.log4j.receivers.db.DriverManagerConnectionSource");
        s.add("com.yeepay.shade.org.apache.log4j.receivers.db.JNDIConnectionSource");
        s.add("net.sf.ehcache.transaction.manager.selector.GenericJndiSelector");
        s.add("net.sf.ehcache.transaction.manager.selector.GlassfishSelector");
        DEFAULT_NO_DESER_CLASS_NAMES = Collections.unmodifiableSet(s);
        instance = new SubTypeValidator();
    }
}

