/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1OutputStream;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1SetParser;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.BERSet;
import com.timevale.tgtext.bouncycastle.asn1.BERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.DLSet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public abstract class ASN1Set
extends ASN1Primitive {
    private Vector set = new Vector();
    private boolean isSorted = false;

    public static ASN1Set getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1Set) {
            return (ASN1Set)obj;
        }
        if (obj instanceof ASN1SetParser) {
            return ASN1Set.getInstance(((ASN1SetParser)obj).toASN1Primitive());
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1Set.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e2) {
                throw new IllegalArgumentException("failed to construct set from byte[]: " + e2.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1Set) {
            return (ASN1Set)primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Set getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (explicit) {
            if (!obj.isExplicit()) {
                throw new IllegalArgumentException("object implicit - explicit expected.");
            }
            return (ASN1Set)obj.getObject();
        }
        if (obj.isExplicit()) {
            if (obj instanceof BERTaggedObject) {
                return new BERSet(obj.getObject());
            }
            return new DLSet(obj.getObject());
        }
        if (obj.getObject() instanceof ASN1Set) {
            return (ASN1Set)obj.getObject();
        }
        if (obj.getObject() instanceof ASN1Sequence) {
            ASN1Sequence s2 = (ASN1Sequence)obj.getObject();
            if (obj instanceof BERTaggedObject) {
                return new BERSet(s2.toArray());
            }
            return new DLSet(s2.toArray());
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    protected ASN1Set() {
    }

    protected ASN1Set(ASN1Encodable obj) {
        this.set.addElement(obj);
    }

    protected ASN1Set(ASN1EncodableVector v2, boolean doSort) {
        for (int i2 = 0; i2 != v2.size(); ++i2) {
            this.set.addElement(v2.get(i2));
        }
        if (doSort) {
            this.sort();
        }
    }

    protected ASN1Set(ASN1Encodable[] array, boolean doSort) {
        for (int i2 = 0; i2 != array.length; ++i2) {
            this.set.addElement(array[i2]);
        }
        if (doSort) {
            this.sort();
        }
    }

    public Enumeration getObjects() {
        return this.set.elements();
    }

    public ASN1Encodable getObjectAt(int index) {
        return (ASN1Encodable)this.set.elementAt(index);
    }

    public int size() {
        return this.set.size();
    }

    public ASN1Encodable[] toArray() {
        ASN1Encodable[] values = new ASN1Encodable[this.size()];
        for (int i2 = 0; i2 != this.size(); ++i2) {
            values[i2] = this.getObjectAt(i2);
        }
        return values;
    }

    public ASN1SetParser parser() {
        final ASN1Set outer = this;
        return new ASN1SetParser(){
            private final int c;
            private int d;
            {
                this.c = ASN1Set.this.size();
            }

            @Override
            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable obj;
                if (this.d == this.c) {
                    return null;
                }
                if ((obj = ASN1Set.this.getObjectAt(this.d++)) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)obj).parser();
                }
                if (obj instanceof ASN1Set) {
                    return ((ASN1Set)obj).parser();
                }
                return obj;
            }

            @Override
            public ASN1Primitive getLoadedObject() {
                return outer;
            }

            @Override
            public ASN1Primitive toASN1Primitive() {
                return outer;
            }
        };
    }

    @Override
    public int hashCode() {
        Enumeration e2 = this.getObjects();
        int hashCode = this.size();
        while (e2.hasMoreElements()) {
            ASN1Encodable o2 = this.getNext(e2);
            hashCode *= 17;
            hashCode ^= o2.hashCode();
        }
        return hashCode;
    }

    @Override
    ASN1Primitive toDERObject() {
        if (this.isSorted) {
            DERSet derSet = new DERSet();
            new DERSet().set = this.set;
            return derSet;
        }
        Vector v2 = new Vector();
        for (int i2 = 0; i2 != this.set.size(); ++i2) {
            v2.addElement(this.set.elementAt(i2));
        }
        DERSet derSet = new DERSet();
        new DERSet().set = v2;
        derSet.sort();
        return derSet;
    }

    @Override
    ASN1Primitive toDLObject() {
        DLSet derSet = new DLSet();
        new DLSet().set = this.set;
        return derSet;
    }

    @Override
    boolean asn1Equals(ASN1Primitive o2) {
        if (!(o2 instanceof ASN1Set)) {
            return false;
        }
        ASN1Set other = (ASN1Set)o2;
        if (this.size() != other.size()) {
            return false;
        }
        Enumeration s1 = this.getObjects();
        Enumeration s2 = other.getObjects();
        while (s1.hasMoreElements()) {
            ASN1Primitive o22;
            ASN1Encodable obj1 = this.getNext(s1);
            ASN1Encodable obj2 = this.getNext(s2);
            ASN1Primitive o1 = obj1.toASN1Primitive();
            if (o1 == (o22 = obj2.toASN1Primitive()) || o1.equals(o22)) continue;
            return false;
        }
        return true;
    }

    private ASN1Encodable getNext(Enumeration e2) {
        ASN1Encodable encObj = (ASN1Encodable)e2.nextElement();
        if (encObj == null) {
            return DERNull.INSTANCE;
        }
        return encObj;
    }

    private boolean lessThanOrEqual(byte[] a2, byte[] b2) {
        int len = Math.min(a2.length, b2.length);
        for (int i2 = 0; i2 != len; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return (a2[i2] & 0xFF) < (b2[i2] & 0xFF);
        }
        return len == a2.length;
    }

    private byte[] getEncoded(ASN1Encodable obj) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ASN1OutputStream aOut = new ASN1OutputStream(bOut);
        try {
            aOut.writeObject(obj);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("cannot encode object added to SET");
        }
        return bOut.toByteArray();
    }

    protected void sort() {
        if (!this.isSorted) {
            this.isSorted = true;
            if (this.set.size() > 1) {
                boolean swapped = true;
                int lastSwap = this.set.size() - 1;
                while (swapped) {
                    int swapIndex = 0;
                    byte[] a2 = this.getEncoded((ASN1Encodable)this.set.elementAt(0));
                    swapped = false;
                    for (int index = 0; index != lastSwap; ++index) {
                        byte[] b2 = this.getEncoded((ASN1Encodable)this.set.elementAt(index + 1));
                        if (this.lessThanOrEqual(a2, b2)) {
                            a2 = b2;
                            continue;
                        }
                        Object o2 = this.set.elementAt(index);
                        this.set.setElementAt(this.set.elementAt(index + 1), index);
                        this.set.setElementAt(o2, index + 1);
                        swapped = true;
                        swapIndex = index;
                    }
                    lastSwap = swapIndex;
                }
            }
        }
    }

    @Override
    boolean isConstructed() {
        return true;
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return this.set.toString();
    }
}

