/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cert.path.validations;

import cfca.sadk.org.bouncycastle.asn1.x509.BasicConstraints;
import cfca.sadk.org.bouncycastle.asn1.x509.Extension;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.path.CertPathValidation;
import cfca.sadk.org.bouncycastle.cert.path.CertPathValidationContext;
import cfca.sadk.org.bouncycastle.cert.path.CertPathValidationException;
import cfca.sadk.org.bouncycastle.util.Memoable;
import java.math.BigInteger;

public class BasicConstraintsValidation
implements CertPathValidation {
    private boolean isMandatory;
    private BasicConstraints bc;
    private int maxPathLength;

    public BasicConstraintsValidation() {
        this(true);
    }

    public BasicConstraintsValidation(boolean isMandatory) {
        this.isMandatory = isMandatory;
    }

    public void validate(CertPathValidationContext context, X509CertificateHolder certificate) throws CertPathValidationException {
        if (this.maxPathLength < 0) {
            throw new CertPathValidationException("BasicConstraints path length exceeded");
        }
        context.addHandledExtension(Extension.basicConstraints);
        BasicConstraints certBC = BasicConstraints.fromExtensions(certificate.getExtensions());
        if (certBC != null) {
            if (this.bc != null) {
                int plc;
                BigInteger pathLengthConstraint;
                if (certBC.isCA() && (pathLengthConstraint = certBC.getPathLenConstraint()) != null && (plc = pathLengthConstraint.intValue()) < this.maxPathLength) {
                    this.maxPathLength = plc;
                    this.bc = certBC;
                }
            } else {
                this.bc = certBC;
                if (certBC.isCA()) {
                    this.maxPathLength = certBC.getPathLenConstraint().intValue();
                }
            }
        } else if (this.bc != null) {
            --this.maxPathLength;
        }
        if (this.isMandatory && this.bc == null) {
            throw new CertPathValidationException("BasicConstraints not present in path");
        }
    }

    public Memoable copy() {
        BasicConstraintsValidation v = new BasicConstraintsValidation(this.isMandatory);
        v.bc = this.bc;
        v.maxPathLength = this.maxPathLength;
        return v;
    }

    public void reset(Memoable other) {
        BasicConstraintsValidation v = (BasicConstraintsValidation)other;
        this.isMandatory = v.isMandatory;
        this.bc = v.bc;
        this.maxPathLength = v.maxPathLength;
    }
}

