/*
 * Decompiled with CFR 0.152.
 */
package esign.utils.cache.ehcache;

import esign.utils.JsonHelper;
import esign.utils.cache.d;
import esign.utils.cache.ehcache.adapter.MemoryUnitAdapter;
import esign.utils.cache.ehcache.adapter.TimeUnitAdapter;
import esign.utils.cache.unit.UtilMemeryUnit;
import esign.utils.cache.unit.UtilTimeUnit;
import esign.utils.exception.ag;
import esign.utils.exception.aj;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.EvictionAdvisor;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.expiry.Duration;
import org.ehcache.expiry.Expirations;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.SerializerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum EhcacheFactory {
    INSTANCE;

    private CacheManager manager = CacheManagerBuilder.newCacheManagerBuilder().build();
    private static final Logger LOGGER;

    private EhcacheFactory() {
        this.manager.init();
    }

    public <K, V> a<K, V> createEhcahe(d<K, V> conf) {
        return new a(conf);
    }

    public a<?, ?> getEhcache(String name) throws aj {
        Map map = this.manager.getRuntimeConfiguration().getCacheConfigurations();
        CacheConfiguration conf = (CacheConfiguration)map.get(name);
        if (conf == null) {
            throw ag.an.a(name);
        }
        return new a(conf.getKeyType(), conf.getValueType());
    }

    static {
        LOGGER = LoggerFactory.getLogger(EhcacheFactory.class);
    }

    private class b<V>
    implements Serializer<V> {
        private static final String b = "utf-8";
        private Class<V> c;

        private b(Class<V> valueClass) {
            this.c = valueClass;
        }

        public ByteBuffer serialize(V object) throws SerializerException {
            try {
                return ByteBuffer.wrap(JsonHelper.a(object).getBytes(b));
            }
            catch (UnsupportedEncodingException e2) {
                LOGGER.error("unsupport encode. encode:{}", (Object)b);
                LOGGER.error("exception:", (Throwable)e2);
                throw new SerializerException("encode failed.", (Throwable)e2);
            }
        }

        public V read(ByteBuffer binary) throws ClassNotFoundException, SerializerException {
            String str;
            CharsetDecoder decoder = Charset.forName(b).newDecoder();
            try {
                str = decoder.decode(binary).toString();
            }
            catch (CharacterCodingException e2) {
                LOGGER.error("decode failed. encode:{}", (Object)b);
                LOGGER.error("exception:", (Throwable)e2);
                throw new SerializerException("decode failed.", (Throwable)e2);
            }
            return JsonHelper.a(str, this.c);
        }

        public boolean equals(V object, ByteBuffer binary) throws ClassNotFoundException, SerializerException {
            return false;
        }
    }

    public class a<K, V> {
        private Class<K> b;
        private Class<V> c;

        private a(d<K, V> conf) {
            this.b = conf.g();
            this.c = conf.h();
            EhcacheFactory.this.manager.createCache(conf.f(), this.a(conf));
        }

        private a(Class<K> keyClass, Class<V> valueClass) {
            this.b = keyClass;
            this.c = valueClass;
        }

        public void a(String name, K key, V value) {
            LOGGER.debug("set cache. name:{}, key:{}", (Object)name, key);
            Cache<K, V> cache = this.d(name);
            cache.put(key, value);
        }

        public V a(String name, K key) {
            LOGGER.debug("get cache. name:{}, key:{}", (Object)name, key);
            Cache<K, V> cache = this.d(name);
            return (V)cache.get(key);
        }

        public void b(String name, K key) {
            LOGGER.debug("delete the cache. name:{}, key:{}", (Object)name, key);
            Cache<K, V> cache = this.d(name);
            cache.remove(key);
        }

        public void a(String name) {
            LOGGER.debug("clear the cache. name:{}", (Object)name);
            EhcacheFactory.this.manager.removeCache(name);
        }

        public List<K> b(String name) {
            LOGGER.debug("get all keys from cache. name:{}", (Object)name);
            Cache<K, V> cache = this.d(name);
            Iterator iter = cache.iterator();
            if (!iter.hasNext()) {
                return null;
            }
            ArrayList<Object> keys = new ArrayList<Object>();
            while (iter.hasNext()) {
                keys.add(((Cache.Entry)iter.next()).getKey());
            }
            return keys;
        }

        public List<V> c(String name) {
            LOGGER.debug("get all values from cache. name:{}", (Object)name);
            Cache<K, V> cache = this.d(name);
            Iterator iter = cache.iterator();
            if (!iter.hasNext()) {
                return null;
            }
            ArrayList<Object> vals = new ArrayList<Object>();
            while (iter.hasNext()) {
                vals.add(((Cache.Entry)iter.next()).getValue());
            }
            return vals;
        }

        private Cache<K, V> d(String name) {
            return EhcacheFactory.this.manager.getCache(name, this.b, this.c);
        }

        private CacheConfiguration<K, V> a(d<K, V> conf) {
            LOGGER.info("create cache for configuration. name:{}", (Object)conf.f());
            ResourcePoolsBuilder resBuilder = ResourcePoolsBuilder.newResourcePoolsBuilder();
            resBuilder = this.a(resBuilder, conf.a());
            resBuilder = this.b(resBuilder, conf.b());
            resBuilder = this.c(resBuilder, conf.c());
            CacheConfigurationBuilder confBuilder = CacheConfigurationBuilder.newCacheConfigurationBuilder(conf.g(), conf.h(), (ResourcePools)resBuilder.build());
            confBuilder = this.a(confBuilder, conf.e());
            confBuilder = this.b(confBuilder, conf.d());
            confBuilder.withEvictionAdvisor(new EvictionAdvisor<K, V>(){

                public boolean adviseAgainstEviction(K key, V value) {
                    return false;
                }
            });
            confBuilder = confBuilder.withValueSerializer(new b(this.c));
            return confBuilder.build();
        }

        private ResourcePoolsBuilder a(ResourcePoolsBuilder builder, esign.utils.cache.unit.a<UtilMemeryUnit> size) {
            if (!this.a(size)) {
                return builder;
            }
            LOGGER.info("create cache for configuration. heap:[{} {}]", (Object)size.b(), (Object)size.a());
            return builder.heap(size.b(), MemoryUnitAdapter.from(size.a()));
        }

        private ResourcePoolsBuilder b(ResourcePoolsBuilder builder, esign.utils.cache.unit.a<UtilMemeryUnit> size) {
            if (!this.a(size)) {
                return builder;
            }
            LOGGER.info("create cache for configuration. offheap:[{} {}]", (Object)size.b(), (Object)size.a());
            return builder.offheap(size.b(), (MemoryUnit)MemoryUnitAdapter.from(size.a()));
        }

        private ResourcePoolsBuilder c(ResourcePoolsBuilder builder, esign.utils.cache.unit.a<UtilMemeryUnit> size) {
            if (!this.a(size)) {
                return builder;
            }
            LOGGER.info("create cache for configuration. disk:[{} {}]", (Object)size.b(), (Object)size.a());
            return builder.disk(size.b(), (MemoryUnit)MemoryUnitAdapter.from(size.a()));
        }

        private CacheConfigurationBuilder<K, V> a(CacheConfigurationBuilder<K, V> builder, esign.utils.cache.unit.a<UtilTimeUnit> size) {
            if (!this.a(size)) {
                return builder;
            }
            LOGGER.info("create cache for configuration. expireidle:[{} {}]", (Object)size.b(), (Object)size.a());
            return builder;
        }

        private CacheConfigurationBuilder<K, V> b(CacheConfigurationBuilder<K, V> builder, esign.utils.cache.unit.a<UtilTimeUnit> size) {
            if (!this.a(size)) {
                return builder;
            }
            LOGGER.info("create cache for configuration. expirelive:[{} {}]", (Object)size.b(), (Object)size.a());
            return builder.withExpiry(Expirations.timeToLiveExpiration((Duration)Duration.of((long)size.b(), (TimeUnit)TimeUnitAdapter.from(size.a()))));
        }

        private <T> boolean a(esign.utils.cache.unit.a<T> size) {
            return size != null && size.b() > 0L && null != size.a();
        }
    }
}

