/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.util.encoders;

import com.timevale.tgtext.bouncycastle.util.encoders.DecoderException;
import com.timevale.tgtext.bouncycastle.util.encoders.Encoder;
import com.timevale.tgtext.bouncycastle.util.encoders.EncoderException;
import com.timevale.tgtext.bouncycastle.util.encoders.UrlBase64Encoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UrlBase64 {
    private static final Encoder encoder = new UrlBase64Encoder();

    public static byte[] encode(byte[] data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.encode(data, 0, data.length, bOut);
        }
        catch (Exception e2) {
            throw new EncoderException("exception encoding URL safe base64 data: " + e2.getMessage(), e2);
        }
        return bOut.toByteArray();
    }

    public static int encode(byte[] data, OutputStream out) throws IOException {
        return encoder.encode(data, 0, data.length, out);
    }

    public static byte[] decode(byte[] data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.decode(data, 0, data.length, bOut);
        }
        catch (Exception e2) {
            throw new DecoderException("exception decoding URL safe base64 string: " + e2.getMessage(), e2);
        }
        return bOut.toByteArray();
    }

    public static int decode(byte[] data, OutputStream out) throws IOException {
        return encoder.decode(data, 0, data.length, out);
    }

    public static byte[] decode(String data) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            encoder.decode(data, bOut);
        }
        catch (Exception e2) {
            throw new DecoderException("exception decoding URL safe base64 string: " + e2.getMessage(), e2);
        }
        return bOut.toByteArray();
    }

    public static int decode(String data, OutputStream out) throws IOException {
        return encoder.decode(data, out);
    }
}

