/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

public final class PolynomialRingGF2 {
    private PolynomialRingGF2() {
    }

    public static int add(int p2, int q2) {
        return p2 ^ q2;
    }

    public static long multiply(int p2, int q2) {
        long result = 0L;
        if (q2 != 0) {
            long q1 = (long)q2 & 0xFFFFFFFFL;
            while (p2 != 0) {
                byte b2 = (byte)(p2 & 1);
                if (b2 == 1) {
                    result ^= q1;
                }
                p2 >>>= 1;
                q1 <<= 1;
            }
        }
        return result;
    }

    public static int modMultiply(int a2, int b2, int r2) {
        int result = 0;
        int p2 = PolynomialRingGF2.remainder(a2, r2);
        int q2 = PolynomialRingGF2.remainder(b2, r2);
        if (q2 != 0) {
            int d2 = 1 << PolynomialRingGF2.degree(r2);
            while (p2 != 0) {
                byte pMod2 = (byte)(p2 & 1);
                if (pMod2 == 1) {
                    result ^= q2;
                }
                p2 >>>= 1;
                if ((q2 <<= 1) < d2) continue;
                q2 ^= r2;
            }
        }
        return result;
    }

    public static int degree(int p2) {
        int result = -1;
        while (p2 != 0) {
            ++result;
            p2 >>>= 1;
        }
        return result;
    }

    public static int degree(long p2) {
        int result = 0;
        while (p2 != 0L) {
            ++result;
            p2 >>>= 1;
        }
        return result - 1;
    }

    public static int remainder(int p2, int q2) {
        int result = p2;
        if (q2 == 0) {
            System.err.println("Error: to be divided by 0");
            return 0;
        }
        while (PolynomialRingGF2.degree(result) >= PolynomialRingGF2.degree(q2)) {
            result ^= q2 << PolynomialRingGF2.degree(result) - PolynomialRingGF2.degree(q2);
        }
        return result;
    }

    public static int rest(long p2, int q2) {
        long p1 = p2;
        if (q2 == 0) {
            System.err.println("Error: to be divided by 0");
            return 0;
        }
        long q1 = (long)q2 & 0xFFFFFFFFL;
        while (p1 >>> 32 != 0L) {
            p1 ^= q1 << PolynomialRingGF2.degree(p1) - PolynomialRingGF2.degree(q1);
        }
        int result = (int)p1;
        while (PolynomialRingGF2.degree(result) >= PolynomialRingGF2.degree(q2)) {
            result ^= q2 << PolynomialRingGF2.degree(result) - PolynomialRingGF2.degree(q2);
        }
        return result;
    }

    public static int gcd(int p2, int q2) {
        int a2 = p2;
        int b2 = q2;
        while (b2 != 0) {
            int c2 = PolynomialRingGF2.remainder(a2, b2);
            a2 = b2;
            b2 = c2;
        }
        return a2;
    }

    public static boolean isIrreducible(int p2) {
        if (p2 == 0) {
            return false;
        }
        int d2 = PolynomialRingGF2.degree(p2) >>> 1;
        int u2 = 2;
        for (int i2 = 0; i2 < d2; ++i2) {
            if (PolynomialRingGF2.gcd((u2 = PolynomialRingGF2.modMultiply(u2, u2, p2)) ^ 2, p2) == 1) continue;
            return false;
        }
        return true;
    }

    public static int getIrreduciblePolynomial(int deg) {
        if (deg < 0) {
            System.err.println("The Degree is negative");
            return 0;
        }
        if (deg > 31) {
            System.err.println("The Degree is more then 31");
            return 0;
        }
        if (deg == 0) {
            return 1;
        }
        int a2 = 1 << deg;
        int b2 = 1 << deg + 1;
        for (int i2 = ++a2; i2 < b2; i2 += 2) {
            if (!PolynomialRingGF2.isIrreducible(i2)) continue;
            return i2;
        }
        return 0;
    }
}

