/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pkcs.jcajce;

import com.timevale.tgtext.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.operator.OutputEncryptor;
import com.timevale.tgtext.bouncycastle.pkcs.PKCS12SafeBagBuilder;
import com.timevale.tgtext.bouncycastle.pkcs.PKCSIOException;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaPKCS12SafeBagBuilder
extends PKCS12SafeBagBuilder {
    public JcaPKCS12SafeBagBuilder(X509Certificate certificate) throws IOException {
        super(JcaPKCS12SafeBagBuilder.convertCert(certificate));
    }

    private static Certificate convertCert(X509Certificate certificate) throws IOException {
        try {
            return Certificate.getInstance(certificate.getEncoded());
        }
        catch (CertificateEncodingException e2) {
            throw new PKCSIOException("cannot encode certificate: " + e2.getMessage(), e2);
        }
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey, OutputEncryptor encryptor) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()), encryptor);
    }

    public JcaPKCS12SafeBagBuilder(PrivateKey privateKey) {
        super(PrivateKeyInfo.getInstance(privateKey.getEncoded()));
    }
}

