/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1GeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERNull;
import com.timevale.tgtext.bouncycastle.asn1.DEROutputStream;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttributeCertificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttributeCertificateInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.Certificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.CertificateList;
import com.timevale.tgtext.bouncycastle.asn1.x509.Extensions;
import com.timevale.tgtext.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.timevale.tgtext.bouncycastle.asn1.x509.TBSCertList;
import com.timevale.tgtext.bouncycastle.asn1.x509.TBSCertificate;
import com.timevale.tgtext.bouncycastle.cert.CertIOException;
import com.timevale.tgtext.bouncycastle.cert.X509AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CRLHolder;
import com.timevale.tgtext.bouncycastle.cert.X509CertificateHolder;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class a {
    private static Set a = Collections.unmodifiableSet(new HashSet());
    private static List b = Collections.unmodifiableList(new ArrayList());

    a() {
    }

    static X509CertificateHolder a(ContentSigner signer, TBSCertificate tbsCert) {
        try {
            return new X509CertificateHolder(com.timevale.tgtext.bouncycastle.cert.a.a(tbsCert, signer.getAlgorithmIdentifier(), com.timevale.tgtext.bouncycastle.cert.a.a(signer, (ASN1Encodable)tbsCert)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certificate signature");
        }
    }

    static X509AttributeCertificateHolder a(ContentSigner signer, AttributeCertificateInfo attrInfo) {
        try {
            return new X509AttributeCertificateHolder(com.timevale.tgtext.bouncycastle.cert.a.a(attrInfo, signer.getAlgorithmIdentifier(), com.timevale.tgtext.bouncycastle.cert.a.a(signer, (ASN1Encodable)attrInfo)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce attribute certificate signature");
        }
    }

    static X509CRLHolder a(ContentSigner signer, TBSCertList tbsCertList) {
        try {
            return new X509CRLHolder(com.timevale.tgtext.bouncycastle.cert.a.a(tbsCertList, signer.getAlgorithmIdentifier(), com.timevale.tgtext.bouncycastle.cert.a.a(signer, (ASN1Encodable)tbsCertList)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("cannot produce certificate signature");
        }
    }

    private static byte[] a(ContentSigner signer, ASN1Encodable tbsObj) throws IOException {
        OutputStream sOut = signer.getOutputStream();
        DEROutputStream dOut = new DEROutputStream(sOut);
        dOut.writeObject(tbsObj);
        sOut.close();
        return signer.getSignature();
    }

    private static Certificate a(TBSCertificate tbsCert, AlgorithmIdentifier sigAlgId, byte[] signature) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(tbsCert);
        v2.add(sigAlgId);
        v2.add(new DERBitString(signature));
        return Certificate.getInstance(new DERSequence(v2));
    }

    private static AttributeCertificate a(AttributeCertificateInfo attrInfo, AlgorithmIdentifier sigAlgId, byte[] signature) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(attrInfo);
        v2.add(sigAlgId);
        v2.add(new DERBitString(signature));
        return AttributeCertificate.getInstance(new DERSequence(v2));
    }

    private static CertificateList a(TBSCertList tbsCertList, AlgorithmIdentifier sigAlgId, byte[] signature) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(tbsCertList);
        v2.add(sigAlgId);
        v2.add(new DERBitString(signature));
        return CertificateList.getInstance(new DERSequence(v2));
    }

    static Set a(Extensions extensions) {
        if (extensions == null) {
            return a;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(extensions.getCriticalExtensionOIDs())));
    }

    static Set b(Extensions extensions) {
        if (extensions == null) {
            return a;
        }
        return Collections.unmodifiableSet(new HashSet<ASN1ObjectIdentifier>(Arrays.asList(extensions.getNonCriticalExtensionOIDs())));
    }

    static List c(Extensions extensions) {
        if (extensions == null) {
            return b;
        }
        return Collections.unmodifiableList(Arrays.asList(extensions.getExtensionOIDs()));
    }

    static void a(ExtensionsGenerator extGenerator, ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws CertIOException {
        try {
            extGenerator.addExtension(oid, isCritical, value);
            return;
        }
        catch (IOException e2) {
            throw new CertIOException("cannot encode extension: " + e2.getMessage(), e2);
        }
    }

    static DERBitString a(boolean[] id) {
        byte[] bytes = new byte[(id.length + 7) / 8];
        for (int i2 = 0; i2 != id.length; ++i2) {
            int n2 = i2 / 8;
            bytes[n2] = (byte)(bytes[n2] | (id[i2] ? 1 << 7 - i2 % 8 : 0));
        }
        int pad = id.length % 8;
        if (pad == 0) {
            return new DERBitString(bytes);
        }
        return new DERBitString(bytes, 8 - pad);
    }

    static boolean[] a(DERBitString bitString) {
        if (bitString != null) {
            byte[] bytes = bitString.getBytes();
            boolean[] boolId = new boolean[(bytes.length << 3) - bitString.getPadBits()];
            for (int i2 = 0; i2 != boolId.length; ++i2) {
                boolId[i2] = (bytes[i2 / 8] & 128 >>> i2 % 8) != 0;
            }
            return boolId;
        }
        return null;
    }

    static Date a(ASN1GeneralizedTime time) {
        try {
            return time.getDate();
        }
        catch (ParseException e2) {
            throw new IllegalStateException("unable to recover date: " + e2.getMessage());
        }
    }

    static boolean a(AlgorithmIdentifier id1, AlgorithmIdentifier id2) {
        if (!id1.getAlgorithm().equals(id2.getAlgorithm())) {
            return false;
        }
        if (id1.getParameters() == null) {
            return id2.getParameters() == null || id2.getParameters().equals(DERNull.INSTANCE);
        }
        if (id2.getParameters() == null) {
            return id1.getParameters() == null || id1.getParameters().equals(DERNull.INSTANCE);
        }
        return id1.getParameters().equals(id2.getParameters());
    }
}

