/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import java.math.BigInteger;

public final class BigIntUtils {
    private BigIntUtils() {
    }

    public static boolean equals(BigInteger[] a2, BigInteger[] b2) {
        int flag = 0;
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 < a2.length; ++i2) {
            flag |= a2[i2].compareTo(b2[i2]);
        }
        return flag == 0;
    }

    public static void fill(BigInteger[] array, BigInteger value) {
        for (int i2 = array.length - 1; i2 >= 0; --i2) {
            array[i2] = value;
        }
    }

    public static BigInteger[] subArray(BigInteger[] input, int start, int end) {
        BigInteger[] result = new BigInteger[end - start];
        System.arraycopy(input, start, result, 0, end - start);
        return result;
    }

    public static int[] toIntArray(BigInteger[] input) {
        int[] result = new int[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            result[i2] = input[i2].intValue();
        }
        return result;
    }

    public static int[] toIntArrayModQ(int q2, BigInteger[] input) {
        BigInteger bq2 = BigInteger.valueOf(q2);
        int[] result = new int[input.length];
        for (int i2 = 0; i2 < input.length; ++i2) {
            result[i2] = input[i2].mod(bq2).intValue();
        }
        return result;
    }

    public static byte[] toMinimalByteArray(BigInteger value) {
        byte[] valBytes = value.toByteArray();
        if (valBytes.length == 1 || (value.bitLength() & 7) != 0) {
            return valBytes;
        }
        byte[] result = new byte[value.bitLength() >> 3];
        System.arraycopy(valBytes, 1, result, 0, result.length);
        return result;
    }
}

