/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra;

import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Matrix;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.GF2mField;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.Permutation;
import com.timevale.tgtext.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import java.security.SecureRandom;

public final class GoppaCode {
    private GoppaCode() {
    }

    public static GF2Matrix createCanonicalCheckMatrix(GF2mField field, PolynomialGF2mSmallM gp) {
        int j2;
        int i2;
        int m2 = field.getDegree();
        int n2 = 1 << m2;
        int t2 = gp.getDegree();
        int[][] hArray = new int[t2][n2];
        int[][] yz = new int[t2][n2];
        for (int j3 = 0; j3 < n2; ++j3) {
            yz[0][j3] = field.inverse(gp.evaluateAt(j3));
        }
        for (i2 = 1; i2 < t2; ++i2) {
            for (j2 = 0; j2 < n2; ++j2) {
                yz[i2][j2] = field.mult(yz[i2 - 1][j2], j2);
            }
        }
        for (i2 = 0; i2 < t2; ++i2) {
            for (j2 = 0; j2 < n2; ++j2) {
                for (int k2 = 0; k2 <= i2; ++k2) {
                    hArray[i2][j2] = field.add(hArray[i2][j2], field.mult(yz[k2][j2], gp.getCoefficient(t2 + k2 - i2)));
                }
            }
        }
        int[][] result = new int[t2 * m2][n2 + 31 >>> 5];
        for (j2 = 0; j2 < n2; ++j2) {
            int q2 = j2 >>> 5;
            int r2 = 1 << (j2 & 0x1F);
            for (int i3 = 0; i3 < t2; ++i3) {
                int e2 = hArray[i3][j2];
                for (int u2 = 0; u2 < m2; ++u2) {
                    int b2 = e2 >>> u2 & 1;
                    if (b2 == 0) continue;
                    int ind = (i3 + 1) * m2 - u2 - 1;
                    int[] nArray = result[ind];
                    int n3 = q2;
                    nArray[n3] = nArray[n3] ^ r2;
                }
            }
        }
        return new GF2Matrix(n2, result);
    }

    public static MaMaPe computeSystematicForm(GF2Matrix h2, SecureRandom sr) {
        GF2Matrix sInv;
        GF2Matrix hp;
        Permutation p2;
        boolean found;
        int n2 = h2.getNumColumns();
        GF2Matrix s2 = null;
        do {
            p2 = new Permutation(n2, sr);
            hp = (GF2Matrix)h2.rightMultiply(p2);
            sInv = hp.getLeftSubMatrix();
            try {
                found = true;
                s2 = (GF2Matrix)sInv.computeInverse();
            }
            catch (ArithmeticException arithmeticException) {
                found = false;
            }
        } while (!found);
        GF2Matrix shp = (GF2Matrix)s2.rightMultiply(hp);
        GF2Matrix m2 = shp.getRightSubMatrix();
        return new MaMaPe(sInv, m2, p2);
    }

    public static GF2Vector syndromeDecode(GF2Vector syndVec, GF2mField field, PolynomialGF2mSmallM gp, PolynomialGF2mSmallM[] sqRootMatrix) {
        int n2 = 1 << field.getDegree();
        GF2Vector errors = new GF2Vector(n2);
        if (!syndVec.isZero()) {
            PolynomialGF2mSmallM syndrome = new PolynomialGF2mSmallM(syndVec.toExtensionFieldVector(field));
            PolynomialGF2mSmallM t2 = syndrome.modInverse(gp);
            PolynomialGF2mSmallM tau = t2.addMonomial(1);
            tau = tau.modSquareRootMatrix(sqRootMatrix);
            PolynomialGF2mSmallM[] ab2 = tau.modPolynomialToFracton(gp);
            PolynomialGF2mSmallM a2 = ab2[0].multiply(ab2[0]);
            PolynomialGF2mSmallM b2 = ab2[1].multiply(ab2[1]);
            PolynomialGF2mSmallM xb2 = b2.multWithMonomial(1);
            PolynomialGF2mSmallM a2plusXb2 = a2.add(xb2);
            int headCoeff = a2plusXb2.getHeadCoefficient();
            int invHeadCoeff = field.inverse(headCoeff);
            PolynomialGF2mSmallM elp = a2plusXb2.multWithElement(invHeadCoeff);
            for (int i2 = 0; i2 < n2; ++i2) {
                int z2 = elp.evaluateAt(i2);
                if (z2 != 0) continue;
                errors.setBit(i2);
            }
        }
        return errors;
    }

    public static class MatrixSet {
        private GF2Matrix g;
        private int[] setJ;

        public MatrixSet(GF2Matrix g2, int[] setJ) {
            this.g = g2;
            this.setJ = setJ;
        }

        public GF2Matrix getG() {
            return this.g;
        }

        public int[] getSetJ() {
            return this.setJ;
        }
    }

    public static class MaMaPe {
        private GF2Matrix s;
        private GF2Matrix h;
        private Permutation p;

        public MaMaPe(GF2Matrix s2, GF2Matrix h2, Permutation p2) {
            this.s = s2;
            this.h = h2;
            this.p = p2;
        }

        public GF2Matrix getFirstMatrix() {
            return this.s;
        }

        public GF2Matrix getSecondMatrix() {
            return this.h;
        }

        public Permutation getPermutation() {
            return this.p;
        }
    }
}

