/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util;

import cfca.sadk.org.bouncycastle.crypto.CipherParameters;
import cfca.sadk.org.bouncycastle.crypto.Mac;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.org.bouncycastle.crypto.params.SkeinParameters;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import cfca.sadk.org.bouncycastle.jcajce.provider.symmetric.util.PBE;
import cfca.sadk.org.bouncycastle.jcajce.spec.SkeinParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.MacSpi;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;

public class BaseMac
extends MacSpi
implements PBE {
    private Mac macEngine;

    protected BaseMac(Mac macEngine) {
        this.macEngine = macEngine;
    }

    protected BaseMac(Mac macEngine, int pbeType, int pbeHash, int keySize) {
        this.macEngine = macEngine;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        CipherParameters param;
        if (key == null) {
            throw new InvalidKeyException("key is null");
        }
        if (key instanceof BCPBEKey) {
            BCPBEKey k = (BCPBEKey)key;
            if (k.getParam() != null) {
                param = k.getParam();
            } else {
                if (!(params instanceof PBEParameterSpec)) throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                param = PBE.Util.makePBEMacParameters(k, params);
            }
        } else if (params instanceof IvParameterSpec) {
            param = new ParametersWithIV(new KeyParameter(key.getEncoded()), ((IvParameterSpec)params).getIV());
        } else if (params instanceof SkeinParameterSpec) {
            param = new SkeinParameters.Builder(BaseMac.copyMap(((SkeinParameterSpec)params).getParameters())).setKey(key.getEncoded()).build();
        } else {
            if (params != null) throw new InvalidAlgorithmParameterException("unknown parameter type.");
            param = new KeyParameter(key.getEncoded());
        }
        this.macEngine.init(param);
    }

    protected int engineGetMacLength() {
        return this.macEngine.getMacSize();
    }

    protected void engineReset() {
        this.macEngine.reset();
    }

    protected void engineUpdate(byte input) {
        this.macEngine.update(input);
    }

    protected void engineUpdate(byte[] input, int offset, int len) {
        this.macEngine.update(input, offset, len);
    }

    protected byte[] engineDoFinal() {
        byte[] out = new byte[this.engineGetMacLength()];
        this.macEngine.doFinal(out, 0);
        return out;
    }

    private static Hashtable copyMap(Map paramsMap) {
        Hashtable newTable = new Hashtable();
        Iterator keys = paramsMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            newTable.put(key, paramsMap.get(key));
        }
        return newTable;
    }
}

