/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.cert.cmp;

import cfca.sadk.org.bouncycastle.asn1.ASN1EncodableVector;
import cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.DERBitString;
import cfca.sadk.org.bouncycastle.asn1.DERSequence;
import cfca.sadk.org.bouncycastle.asn1.cmp.CMPCertificate;
import cfca.sadk.org.bouncycastle.asn1.cmp.InfoTypeAndValue;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIBody;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIFreeText;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIHeader;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import cfca.sadk.org.bouncycastle.asn1.cmp.PKIMessage;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cert.cmp.CMPException;
import cfca.sadk.org.bouncycastle.cert.cmp.ProtectedPKIMessage;
import cfca.sadk.org.bouncycastle.operator.ContentSigner;
import cfca.sadk.org.bouncycastle.operator.MacCalculator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ProtectedPKIMessageBuilder {
    private PKIHeaderBuilder hdrBuilder;
    private PKIBody body;
    private List generalInfos = new ArrayList();
    private List extraCerts = new ArrayList();

    public ProtectedPKIMessageBuilder(GeneralName sender, GeneralName recipient) {
        this(2, sender, recipient);
    }

    public ProtectedPKIMessageBuilder(int pvno, GeneralName sender, GeneralName recipient) {
        this.hdrBuilder = new PKIHeaderBuilder(pvno, sender, recipient);
    }

    public ProtectedPKIMessageBuilder setTransactionID(byte[] tid) {
        this.hdrBuilder.setTransactionID(tid);
        return this;
    }

    public ProtectedPKIMessageBuilder setFreeText(PKIFreeText freeText) {
        this.hdrBuilder.setFreeText(freeText);
        return this;
    }

    public ProtectedPKIMessageBuilder addGeneralInfo(InfoTypeAndValue genInfo) {
        this.generalInfos.add(genInfo);
        return this;
    }

    public ProtectedPKIMessageBuilder setMessageTime(Date time) {
        this.hdrBuilder.setMessageTime(new ASN1GeneralizedTime(time));
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipKID(byte[] kid) {
        this.hdrBuilder.setRecipKID(kid);
        return this;
    }

    public ProtectedPKIMessageBuilder setRecipNonce(byte[] nonce) {
        this.hdrBuilder.setRecipNonce(nonce);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderKID(byte[] kid) {
        this.hdrBuilder.setSenderKID(kid);
        return this;
    }

    public ProtectedPKIMessageBuilder setSenderNonce(byte[] nonce) {
        this.hdrBuilder.setSenderNonce(nonce);
        return this;
    }

    public ProtectedPKIMessageBuilder setBody(PKIBody body) {
        this.body = body;
        return this;
    }

    public ProtectedPKIMessageBuilder addCMPCertificate(X509CertificateHolder extraCert) {
        this.extraCerts.add(extraCert);
        return this;
    }

    public ProtectedPKIMessage build(MacCalculator macCalculator) throws CMPException {
        this.finaliseHeader(macCalculator.getAlgorithmIdentifier());
        PKIHeader header = this.hdrBuilder.build();
        try {
            DERBitString protection = new DERBitString(this.calculateMac(macCalculator, header, this.body));
            return this.finaliseMessage(header, protection);
        }
        catch (IOException e) {
            throw new CMPException("unable to encode MAC input: " + e.getMessage(), e);
        }
    }

    public ProtectedPKIMessage build(ContentSigner signer) throws CMPException {
        this.finaliseHeader(signer.getAlgorithmIdentifier());
        PKIHeader header = this.hdrBuilder.build();
        try {
            DERBitString protection = new DERBitString(this.calculateSignature(signer, header, this.body));
            return this.finaliseMessage(header, protection);
        }
        catch (IOException e) {
            throw new CMPException("unable to encode signature input: " + e.getMessage(), e);
        }
    }

    private void finaliseHeader(AlgorithmIdentifier algorithmIdentifier) {
        this.hdrBuilder.setProtectionAlg(algorithmIdentifier);
        if (!this.generalInfos.isEmpty()) {
            InfoTypeAndValue[] genInfos = new InfoTypeAndValue[this.generalInfos.size()];
            this.hdrBuilder.setGeneralInfo(this.generalInfos.toArray(genInfos));
        }
    }

    private ProtectedPKIMessage finaliseMessage(PKIHeader header, DERBitString protection) {
        if (!this.extraCerts.isEmpty()) {
            CMPCertificate[] cmpCerts = new CMPCertificate[this.extraCerts.size()];
            for (int i = 0; i != cmpCerts.length; ++i) {
                cmpCerts[i] = new CMPCertificate(((X509CertificateHolder)this.extraCerts.get(i)).toASN1Structure());
            }
            return new ProtectedPKIMessage(new PKIMessage(header, this.body, protection, cmpCerts));
        }
        return new ProtectedPKIMessage(new PKIMessage(header, this.body, protection));
    }

    private byte[] calculateSignature(ContentSigner signer, PKIHeader header, PKIBody body) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(header);
        v.add(body);
        OutputStream sOut = signer.getOutputStream();
        sOut.write(new DERSequence(v).getEncoded("DER"));
        sOut.close();
        return signer.getSignature();
    }

    private byte[] calculateMac(MacCalculator macCalculator, PKIHeader header, PKIBody body) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(header);
        v.add(body);
        OutputStream sOut = macCalculator.getOutputStream();
        sOut.write(new DERSequence(v).getEncoded("DER"));
        sOut.close();
        return macCalculator.getMac();
    }
}

