/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.util.InitKeyStore;
import cfca.sadk.algorithm.util.P7BParser;
import cfca.sadk.algorithm.util.SM2OIDUtil;
import cfca.sadk.asn1.pkcs.PKCS12;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.BasicConstraints;
import cfca.sadk.org.bouncycastle.asn1.x509.Extensions;
import cfca.sadk.system.FileHelper;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;

public class CertUtil {
    public static byte[] getCertExtensionData(X509Cert x509Cert, String oid) throws PKIException {
        if (x509Cert == null) {
            throw new IllegalArgumentException("x509Cert should not be null");
        }
        if (oid == null) {
            throw new IllegalArgumentException("oid should not be null");
        }
        try {
            byte[] extension = x509Cert.getExtensionByteData(new ASN1ObjectIdentifier(oid));
            if (extension == null) {
                return null;
            }
            byte b = extension[1];
            int blen = b & 0x80;
            if (blen == 0) {
                byte[] ret = new byte[extension.length - 2];
                System.arraycopy(extension, 2, ret, 0, extension.length - 2);
                return ret;
            }
            blen = b & 0x7F;
            byte[] ret = new byte[extension.length - 2 - blen];
            System.arraycopy(extension, 2 + blen, ret, 0, extension.length - 2 - blen);
            return ret;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("GetExtension failure", e);
        }
    }

    public static Extensions getCertExtensionsData(X509Cert x509Cert) {
        if (x509Cert == null) {
            throw new IllegalArgumentException("x509Cert should not be null");
        }
        return x509Cert.getExtensionsData();
    }

    public static X509Cert getCertFromSM2(String sm2FilePath) throws PKIException {
        byte[] encoding;
        if (sm2FilePath == null) {
            throw new PKIException("SM2File sm2FilePath should not be null");
        }
        try {
            encoding = FileHelper.read(sm2FilePath);
        }
        catch (Exception e) {
            throw new PKIException("SM2File read failure", e);
        }
        return CertUtil.getCertFromSM2(encoding);
    }

    public static X509Cert getCertFromSM2(InputStream sm2FileInputStream) throws PKIException {
        byte[] encoding;
        int dLength;
        if (sm2FileInputStream == null) {
            throw new PKIException("SM2File sm2FileInputStream should not be null");
        }
        try {
            dLength = sm2FileInputStream.available();
        }
        catch (IOException e) {
            throw new PKIException("SM2File sm2FileInputStream invalid", e);
        }
        if (dLength > 1024000) {
            throw new PKIException("SM2File sm2FileInputStream too large");
        }
        try {
            encoding = new byte[dLength];
            sm2FileInputStream.read(encoding);
        }
        catch (Exception e) {
            throw new PKIException("SM2File sm2FileInputStream read failure", e);
        }
        return CertUtil.getCertFromSM2(encoding);
    }

    public static X509Cert getCertFromSM2(byte[] sm2FileData) throws PKIException {
        if (sm2FileData == null) {
            throw new PKIException("SM2File sm2FileData should not be null");
        }
        PKCS12_SM2 P12 = new PKCS12_SM2(sm2FileData);
        return P12.getPublicCert()[0];
    }

    public static X509Cert getCertFromPFX(String pfxFilePath, String pfxFilePwd) throws PKIException {
        byte[] encoding;
        if (pfxFilePath == null) {
            throw new PKIException("PFXFile pfxFilePath should not be null");
        }
        try {
            encoding = FileHelper.read(pfxFilePath);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile read failure", e);
        }
        return CertUtil.getCertFromPFX(encoding, pfxFilePwd);
    }

    public static X509Cert getCertFromPFX(InputStream pfxFileInputStream, String pfxFilePwd) throws PKIException {
        byte[] encoding;
        int dLength;
        if (pfxFileInputStream == null) {
            throw new PKIException("PFXFile pfxFileInputStream should not be null");
        }
        try {
            dLength = pfxFileInputStream.available();
        }
        catch (IOException e) {
            throw new PKIException("PFXFile pfxFileInputStream invalid", e);
        }
        if (dLength > 1024000) {
            throw new PKIException("PFXFile pfxFileInputStream too large");
        }
        try {
            encoding = new byte[dLength];
            pfxFileInputStream.read(encoding);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile pfxFileInputStream read failure", e);
        }
        return CertUtil.getCertFromPFX(encoding, pfxFilePwd);
    }

    public static X509Cert getCertFromPFX(byte[] pfxFileData, String pfxFilePwd) throws PKIException {
        if (pfxFileData == null) {
            throw new PKIException("PFXFile pfxFileData should not be null");
        }
        if (pfxFilePwd == null) {
            throw new PKIException("PFXFile pfxFilePwd should not be null");
        }
        PKCS12 P12 = new PKCS12(pfxFileData);
        try {
            P12.decrypt(pfxFilePwd.toCharArray());
        }
        catch (Exception e) {
            throw new PKIException("PFXFile pfxFileData decrypting failure", e);
        }
        return P12.getCerts()[0];
    }

    public static X509Cert getCertFromJKS(String jksFilePath, String jksFilePwd, String alias) throws PKIException {
        if (jksFilePath == null) {
            throw new PKIException("JKSFile jksFilePath should not be null");
        }
        if (jksFilePwd == null) {
            throw new PKIException("JKSFile jksFilePwd should not be null");
        }
        if (alias == null) {
            throw new PKIException("JKSFile alias should not be null");
        }
        try {
            KeyStore keyStore = InitKeyStore.initJKSKeyStore(jksFilePath, jksFilePwd);
            Certificate certificate = keyStore.getCertificate(alias);
            if (certificate != null) {
                return new X509Cert(certificate.getEncoded());
            }
            throw new PKIException("no such alias cert!");
        }
        catch (Exception e) {
            throw new PKIException("JKSFile parsed failure", e);
        }
    }

    public static X509Cert[] parseP7B(String p7bFilePath) throws PKIException {
        byte[] encoding;
        if (p7bFilePath == null) {
            throw new PKIException("P7BFile p7bFilePath should not be null");
        }
        try {
            encoding = FileHelper.read(p7bFilePath);
        }
        catch (Exception e) {
            throw new PKIException("P7BFile read failure", e);
        }
        return CertUtil.parseP7B(encoding);
    }

    public static X509Cert[] parseP7B(byte[] p7bData) throws PKIException {
        if (p7bData == null) {
            throw new PKIException("P7BFile p7bData should not be null");
        }
        try {
            return P7BParser.parseP7B(p7bData);
        }
        catch (Exception e) {
            throw new PKIException("P7BFile parsed failure", e);
        }
    }

    public static void generateP7BFile(X509Cert[] certs, String outP7bFilePath) throws PKIException {
        if (certs == null) {
            throw new PKIException("P7BFile certs should not be null");
        }
        if (outP7bFilePath == null) {
            throw new PKIException("P7BFile outP7bFilePath should not be null");
        }
        try {
            P7BParser.generateP7BFile(certs, outP7bFilePath);
        }
        catch (Exception e) {
            throw new PKIException("P7BFile Generated failure", e);
        }
    }

    public static void generateP7BFile(X509Cert[] certs, OutputStream out) throws PKIException {
        if (certs == null) {
            throw new PKIException("P7BFile certs should not be null");
        }
        if (out == null) {
            throw new PKIException("P7BFile OutputStream should not be null");
        }
        try {
            P7BParser.generateP7BFile(certs, out);
        }
        catch (Exception e) {
            throw new PKIException("P7BFile Generated failure", e);
        }
    }

    public static byte[] generateP7BData(X509Cert[] certs) throws PKIException {
        if (certs == null) {
            throw new PKIException("P7BFile certs should not be null");
        }
        try {
            byte[] base64Data = P7BParser.generateP7BData(certs);
            return base64Data;
        }
        catch (Exception e) {
            throw new PKIException("P7BFile Generated failure", e);
        }
    }

    public static boolean isSM2Cert(X509Cert x509Cert) {
        if (x509Cert == null) {
            throw new IllegalArgumentException("x509Cert should not be null");
        }
        return SM2OIDUtil.isSm3WithSM2Encryption(x509Cert.getCertStructure().getSignatureAlgorithm().getAlgorithm());
    }

    public static boolean isCACert(X509Cert x509Cert) throws PKIException {
        if (x509Cert == null) {
            throw new IllegalArgumentException("x509Cert should not be null");
        }
        boolean isCA = false;
        BasicConstraints bcs = x509Cert.getBasicConstraints();
        if (bcs != null) {
            isCA = bcs.isCA();
        }
        return isCA;
    }
}

