/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.timevale.tgtext.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.timevale.tgtext.bouncycastle.crypto.KeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUSigningKeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUSigningPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUSigningPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.math.ntru.euclid.BigIntEuclidean;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.BigDecimalPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.BigIntPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.DenseTernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Polynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.ProductFormPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Resultant;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class NTRUSigningKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUSigningKeyGenerationParameters params;

    @Override
    public void init(KeyGenerationParameters param) {
        this.params = (NTRUSigningKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUSigningPublicKeyParameters pub = null;
        ExecutorService executor = Executors.newCachedThreadPool();
        ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>> bases = new ArrayList<Future<NTRUSigningPrivateKeyParameters.Basis>>();
        for (int k2 = this.params.B; k2 >= 0; --k2) {
            bases.add(executor.submit(new a()));
        }
        executor.shutdown();
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> basises = new ArrayList<NTRUSigningPrivateKeyParameters.Basis>();
        for (int k3 = this.params.B; k3 >= 0; --k3) {
            Future basis = (Future)bases.get(k3);
            try {
                basises.add((NTRUSigningPrivateKeyParameters.Basis)basis.get());
                if (k3 != this.params.B) continue;
                pub = new NTRUSigningPublicKeyParameters(((NTRUSigningPrivateKeyParameters.Basis)basis.get()).h, this.params.getSigningParameters());
                continue;
            }
            catch (Exception e2) {
                throw new IllegalStateException(e2);
            }
        }
        NTRUSigningPrivateKeyParameters priv = new NTRUSigningPrivateKeyParameters(basises, pub);
        AsymmetricCipherKeyPair kp = new AsymmetricCipherKeyPair(pub, priv);
        return kp;
    }

    public AsymmetricCipherKeyPair generateKeyPairSingleThread() {
        ArrayList<NTRUSigningPrivateKeyParameters.Basis> basises = new ArrayList<NTRUSigningPrivateKeyParameters.Basis>();
        NTRUSigningPublicKeyParameters pub = null;
        for (int k2 = this.params.B; k2 >= 0; --k2) {
            NTRUSigningPrivateKeyParameters.Basis basis = this.generateBoundedBasis();
            basises.add(basis);
            if (k2 != 0) continue;
            pub = new NTRUSigningPublicKeyParameters(basis.h, this.params.getSigningParameters());
        }
        NTRUSigningPrivateKeyParameters priv = new NTRUSigningPrivateKeyParameters(basises, pub);
        return new AsymmetricCipherKeyPair(pub, priv);
    }

    private void minimizeFG(IntegerPolynomial f2, IntegerPolynomial g2, IntegerPolynomial F, IntegerPolynomial G, int N) {
        int E = 0;
        for (int j2 = 0; j2 < N; ++j2) {
            E += 2 * N * (f2.coeffs[j2] * f2.coeffs[j2] + g2.coeffs[j2] * g2.coeffs[j2]);
        }
        E -= 4;
        IntegerPolynomial u2 = (IntegerPolynomial)f2.clone();
        IntegerPolynomial v2 = (IntegerPolynomial)g2.clone();
        int k2 = 0;
        for (int j3 = 0; k2 < N && j3 < N; ++j3) {
            int D1;
            int D = 0;
            for (int i2 = 0; i2 < N; ++i2) {
                D1 = F.coeffs[i2] * f2.coeffs[i2];
                int D2 = G.coeffs[i2] * g2.coeffs[i2];
                int D3 = 4 * N * (D1 + D2);
                D += D3;
            }
            D1 = 4 * (F.sumCoeffs() + G.sumCoeffs());
            if ((D -= D1) > E) {
                F.sub(u2);
                G.sub(v2);
                ++k2;
                j3 = 0;
            } else if (D < -E) {
                F.add(u2);
                G.add(v2);
                ++k2;
                j3 = 0;
            }
            u2.rotate1();
            v2.rotate1();
        }
    }

    private FGBasis generateBasis() {
        IntegerPolynomial h2;
        IntegerPolynomial fPrime;
        BigIntPolynomial C;
        BigIntEuclidean r2;
        Resultant rg;
        IntegerPolynomial gInt;
        DenseTernaryPolynomial g2;
        DenseTernaryPolynomial f2;
        IntegerPolynomial fq2;
        IntegerPolynomial fInt;
        int N = this.params.N;
        int q2 = this.params.q;
        int d2 = this.params.d;
        int d1 = this.params.d1;
        int d22 = this.params.d2;
        int d3 = this.params.d3;
        int basisType = this.params.basisType;
        int _2n1 = 2 * N + 1;
        boolean primeCheck = this.params.primeCheck;
        do {
            f2 = this.params.polyType == 0 ? DenseTernaryPolynomial.generateRandom(N, d2 + 1, d2, new SecureRandom()) : ProductFormPolynomial.generateRandom(N, d1, d22, d3 + 1, d3, new SecureRandom());
            fInt = f2.toIntegerPolynomial();
        } while (primeCheck && fInt.resultant((int)_2n1).res.equals(BigInteger.ZERO) || (fq2 = fInt.invertFq(q2)) == null);
        Resultant rf = fInt.resultant();
        while (true) {
            g2 = this.params.polyType == 0 ? DenseTernaryPolynomial.generateRandom(N, d2 + 1, d2, new SecureRandom()) : ProductFormPolynomial.generateRandom(N, d1, d22, d3 + 1, d3, new SecureRandom());
            gInt = g2.toIntegerPolynomial();
            if (primeCheck && gInt.resultant((int)_2n1).res.equals(BigInteger.ZERO) || gInt.invertFq(q2) == null) continue;
            rg = gInt.resultant();
            r2 = BigIntEuclidean.calculate(rf.res, rg.res);
            if (r2.gcd.equals(BigInteger.ONE)) break;
        }
        BigIntPolynomial A = (BigIntPolynomial)rf.rho.clone();
        A.mult(r2.x.multiply(BigInteger.valueOf(q2)));
        BigIntPolynomial B = (BigIntPolynomial)rg.rho.clone();
        B.mult(r2.y.multiply(BigInteger.valueOf(-q2)));
        if (this.params.keyGenAlg == 0) {
            int[] fRevCoeffs = new int[N];
            int[] gRevCoeffs = new int[N];
            fRevCoeffs[0] = fInt.coeffs[0];
            gRevCoeffs[0] = gInt.coeffs[0];
            for (int i2 = 1; i2 < N; ++i2) {
                fRevCoeffs[i2] = fInt.coeffs[N - i2];
                gRevCoeffs[i2] = gInt.coeffs[N - i2];
            }
            IntegerPolynomial fRev = new IntegerPolynomial(fRevCoeffs);
            IntegerPolynomial gRev = new IntegerPolynomial(gRevCoeffs);
            IntegerPolynomial t2 = f2.mult(fRev);
            t2.add(g2.mult(gRev));
            Resultant rt = t2.resultant();
            C = fRev.mult(B);
            C.add(gRev.mult(A));
            C = C.mult(rt.rho);
            C.div(rt.res);
        } else {
            int log10N = 0;
            for (int i3 = 1; i3 < N; i3 *= 10) {
                ++log10N;
            }
            BigDecimalPolynomial fInv = rf.rho.div(new BigDecimal(rf.res), B.getMaxCoeffLength() + 1 + log10N);
            BigDecimalPolynomial gInv = rg.rho.div(new BigDecimal(rg.res), A.getMaxCoeffLength() + 1 + log10N);
            BigDecimalPolynomial Cdec = fInv.mult(B);
            Cdec.add(gInv.mult(A));
            Cdec.halve();
            C = Cdec.round();
        }
        BigIntPolynomial F = (BigIntPolynomial)B.clone();
        F.sub(f2.mult(C));
        BigIntPolynomial G = (BigIntPolynomial)A.clone();
        G.sub(g2.mult(C));
        IntegerPolynomial FInt = new IntegerPolynomial(F);
        IntegerPolynomial GInt = new IntegerPolynomial(G);
        this.minimizeFG(fInt, gInt, FInt, GInt, N);
        if (basisType == 0) {
            fPrime = FInt;
            h2 = g2.mult(fq2, q2);
        } else {
            fPrime = g2;
            h2 = FInt.mult(fq2, q2);
        }
        h2.modPositive(q2);
        return new FGBasis(f2, fPrime, h2, FInt, GInt, this.params);
    }

    public NTRUSigningPrivateKeyParameters.Basis generateBoundedBasis() {
        FGBasis basis;
        while (!(basis = this.generateBasis()).isNormOk()) {
        }
        return basis;
    }

    public class FGBasis
    extends NTRUSigningPrivateKeyParameters.Basis {
        public IntegerPolynomial F;
        public IntegerPolynomial G;

        FGBasis(Polynomial f2, Polynomial fPrime, IntegerPolynomial h2, IntegerPolynomial F, IntegerPolynomial G, NTRUSigningKeyGenerationParameters params) {
            super(f2, fPrime, h2, params);
            this.F = F;
            this.G = G;
        }

        boolean isNormOk() {
            double keyNormBoundSq = ((NTRUSigningKeyPairGenerator)NTRUSigningKeyPairGenerator.this).params.keyNormBoundSq;
            int q2 = ((NTRUSigningKeyPairGenerator)NTRUSigningKeyPairGenerator.this).params.q;
            return (double)this.F.centeredNormSq(q2) < keyNormBoundSq && (double)this.G.centeredNormSq(q2) < keyNormBoundSq;
        }
    }

    private class a
    implements Callable<NTRUSigningPrivateKeyParameters.Basis> {
        private a() {
        }

        public NTRUSigningPrivateKeyParameters.Basis a() throws Exception {
            return NTRUSigningKeyPairGenerator.this.generateBoundedBasis();
        }

        @Override
        public /* synthetic */ Object call() throws Exception {
            return this.a();
        }
    }
}

