/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1GeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERBitString;
import com.timevale.tgtext.bouncycastle.asn1.DERObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttCertIssuer;
import com.timevale.tgtext.bouncycastle.asn1.x509.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttributeCertificate;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttributeCertificateInfo;
import com.timevale.tgtext.bouncycastle.asn1.x509.V2AttributeCertificateInfoGenerator;
import com.timevale.tgtext.bouncycastle.asn1.x509.X509ExtensionsGenerator;
import com.timevale.tgtext.bouncycastle.x509.AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.x509.AttributeCertificateIssuer;
import com.timevale.tgtext.bouncycastle.x509.X509Attribute;
import com.timevale.tgtext.bouncycastle.x509.X509AttributeCertificate;
import com.timevale.tgtext.bouncycastle.x509.X509V2AttributeCertificate;
import com.timevale.tgtext.bouncycastle.x509.a;
import com.timevale.tgtext.bouncycastle.x509.b;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.Date;
import java.util.Iterator;

public class X509V2AttributeCertificateGenerator {
    private V2AttributeCertificateInfoGenerator acInfoGen = new V2AttributeCertificateInfoGenerator();
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator = new X509ExtensionsGenerator();

    public void reset() {
        this.acInfoGen = new V2AttributeCertificateInfoGenerator();
        this.extGenerator.reset();
    }

    public void setHolder(AttributeCertificateHolder holder) {
        this.acInfoGen.setHolder(holder.holder);
    }

    public void setIssuer(AttributeCertificateIssuer issuer) {
        this.acInfoGen.setIssuer(AttCertIssuer.getInstance(issuer.form));
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.acInfoGen.setSerialNumber(new ASN1Integer(serialNumber));
    }

    public void setNotBefore(Date date) {
        this.acInfoGen.setStartDate(new ASN1GeneralizedTime(date));
    }

    public void setNotAfter(Date date) {
        this.acInfoGen.setEndDate(new ASN1GeneralizedTime(date));
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        try {
            this.sigOID = b.a(signatureAlgorithm);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = b.a(this.sigOID, signatureAlgorithm);
        this.acInfoGen.setSignature(this.sigAlgId);
    }

    public void addAttribute(X509Attribute attribute) {
        this.acInfoGen.addAttribute(Attribute.getInstance(attribute.toASN1Object()));
    }

    public void setIssuerUniqueId(boolean[] iui) {
        throw new RuntimeException("not implemented (yet)");
    }

    public void addExtension(String oid, boolean critical, ASN1Encodable value) throws IOException {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(oid), critical, value);
    }

    public void addExtension(String oid, boolean critical, byte[] value) {
        this.extGenerator.addExtension(new ASN1ObjectIdentifier(oid), critical, value);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey key, String provider) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateCertificate(key, provider, null);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey key, String provider, SecureRandom random) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generate(key, provider, random);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            NoSuchProviderException e2 = noSuchProviderException;
            throw noSuchProviderException;
        }
        catch (SignatureException signatureException) {
            SignatureException e3 = signatureException;
            throw signatureException;
        }
        catch (InvalidKeyException invalidKeyException) {
            InvalidKeyException e4 = invalidKeyException;
            throw invalidKeyException;
        }
        catch (GeneralSecurityException e5) {
            throw new SecurityException("exception creating certificate: " + e5);
        }
    }

    public X509AttributeCertificate generate(PrivateKey key, String provider) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        return this.generate(key, provider, null);
    }

    public X509AttributeCertificate generate(PrivateKey key, String provider, SecureRandom random) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.extGenerator.isEmpty()) {
            this.acInfoGen.setExtensions(this.extGenerator.generate());
        }
        AttributeCertificateInfo acInfo = this.acInfoGen.generateAttributeCertificateInfo();
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        v2.add(acInfo);
        v2.add(this.sigAlgId);
        try {
            v2.add(new DERBitString(b.a(this.sigOID, this.signatureAlgorithm, provider, key, random, acInfo)));
            return new X509V2AttributeCertificate(new AttributeCertificate(new DERSequence(v2)));
        }
        catch (IOException e2) {
            throw new a("constructed invalid certificate", e2);
        }
    }

    public Iterator getSignatureAlgNames() {
        return b.a();
    }
}

