/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.generators;

import com.timevale.tgtext.bouncycastle.crypto.CipherKeyGenerator;
import com.timevale.tgtext.bouncycastle.crypto.KeyGenerationParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.DESParameters;

public class DESKeyGenerator
extends CipherKeyGenerator {
    @Override
    public void init(KeyGenerationParameters param) {
        super.init(param);
        if (this.strength == 0 || this.strength == 7) {
            this.strength = 8;
            return;
        }
        if (this.strength != 8) {
            throw new IllegalArgumentException("DES key must be 64 bits long.");
        }
    }

    @Override
    public byte[] generateKey() {
        byte[] newKey = new byte[8];
        do {
            this.random.nextBytes(newKey);
            DESParameters.setOddParity(newKey);
        } while (DESParameters.isWeakKey(newKey, 0));
        return newKey;
    }
}

