/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIFreeText;

public class PollRepContent
extends ASN1Object {
    private ASN1Integer[] certReqId;
    private ASN1Integer[] checkAfter;
    private PKIFreeText[] reason;

    private PollRepContent(ASN1Sequence seq) {
        this.certReqId = new ASN1Integer[seq.size()];
        this.checkAfter = new ASN1Integer[seq.size()];
        this.reason = new PKIFreeText[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            ASN1Sequence s2 = ASN1Sequence.getInstance(seq.getObjectAt(i2));
            this.certReqId[i2] = ASN1Integer.getInstance(s2.getObjectAt(0));
            this.checkAfter[i2] = ASN1Integer.getInstance(s2.getObjectAt(1));
            if (s2.size() <= 2) continue;
            this.reason[i2] = PKIFreeText.getInstance(s2.getObjectAt(2));
        }
    }

    public static PollRepContent getInstance(Object o2) {
        if (o2 instanceof PollRepContent) {
            return (PollRepContent)o2;
        }
        if (o2 != null) {
            return new PollRepContent(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public PollRepContent(ASN1Integer certReqId, ASN1Integer checkAfter) {
        this(certReqId, checkAfter, null);
    }

    public PollRepContent(ASN1Integer certReqId, ASN1Integer checkAfter, PKIFreeText reason) {
        this.certReqId = new ASN1Integer[1];
        this.checkAfter = new ASN1Integer[1];
        this.reason = new PKIFreeText[1];
        this.certReqId[0] = certReqId;
        this.checkAfter[0] = checkAfter;
        this.reason[0] = reason;
    }

    public int size() {
        return this.certReqId.length;
    }

    public ASN1Integer getCertReqId(int index) {
        return this.certReqId[index];
    }

    public ASN1Integer getCheckAfter(int index) {
        return this.checkAfter[index];
    }

    public PKIFreeText getReason(int index) {
        return this.reason[index];
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector outer = new ASN1EncodableVector();
        for (int i2 = 0; i2 != this.certReqId.length; ++i2) {
            ASN1EncodableVector v2 = new ASN1EncodableVector();
            v2.add(this.certReqId[i2]);
            v2.add(this.checkAfter[i2]);
            if (this.reason[i2] != null) {
                v2.add(this.reason[i2]);
            }
            outer.add(new DERSequence(v2));
        }
        return new DERSequence(outer);
    }
}

