/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.engines;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.DataLengthException;
import com.timevale.tgtext.bouncycastle.crypto.params.KeyParameter;

public class SerpentEngine
implements BlockCipher {
    private static final int BLOCK_SIZE = 16;
    static final int ROUNDS = 32;
    static final int PHI = -1640531527;
    private boolean encrypting;
    private int[] wKey;
    private int X0;
    private int X1;
    private int X2;
    private int X3;

    @Override
    public void init(boolean encrypting, CipherParameters params) {
        if (params instanceof KeyParameter) {
            this.encrypting = encrypting;
            this.wKey = this.makeWorkingKey(((KeyParameter)params).getKey());
            return;
        }
        throw new IllegalArgumentException("invalid parameter passed to Serpent init - " + params.getClass().getName());
    }

    @Override
    public String getAlgorithmName() {
        return "Serpent";
    }

    @Override
    public int getBlockSize() {
        return 16;
    }

    @Override
    public final int processBlock(byte[] in, int inOff, byte[] out, int outOff) {
        if (this.wKey == null) {
            throw new IllegalStateException("Serpent not initialised");
        }
        if (inOff + 16 > in.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (outOff + 16 > out.length) {
            throw new DataLengthException("output buffer too short");
        }
        if (this.encrypting) {
            this.encryptBlock(in, inOff, out, outOff);
        } else {
            this.decryptBlock(in, inOff, out, outOff);
        }
        return 16;
    }

    @Override
    public void reset() {
    }

    private int[] makeWorkingKey(byte[] key) throws IllegalArgumentException {
        int i2;
        int off;
        int[] kPad = new int[16];
        int length = 0;
        for (off = key.length - 4; off > 0; off -= 4) {
            kPad[length++] = this.bytesToWord(key, off);
        }
        if (off == 0) {
            kPad[length++] = this.bytesToWord(key, 0);
            if (length < 8) {
                kPad[length] = 1;
            }
        } else {
            throw new IllegalArgumentException("key must be a multiple of 4 bytes");
        }
        int[] w2 = new int[132];
        for (i2 = 8; i2 < 16; ++i2) {
            kPad[i2] = this.rotateLeft(kPad[i2 - 8] ^ kPad[i2 - 5] ^ kPad[i2 - 3] ^ kPad[i2 - 1] ^ 0x9E3779B9 ^ i2 - 8, 11);
        }
        System.arraycopy(kPad, 8, w2, 0, 8);
        for (i2 = 8; i2 < 132; ++i2) {
            w2[i2] = this.rotateLeft(w2[i2 - 8] ^ w2[i2 - 5] ^ w2[i2 - 3] ^ w2[i2 - 1] ^ 0x9E3779B9 ^ i2, 11);
        }
        this.sb3(w2[0], w2[1], w2[2], w2[3]);
        w2[0] = this.X0;
        w2[1] = this.X1;
        w2[2] = this.X2;
        w2[3] = this.X3;
        this.sb2(w2[4], w2[5], w2[6], w2[7]);
        w2[4] = this.X0;
        w2[5] = this.X1;
        w2[6] = this.X2;
        w2[7] = this.X3;
        this.sb1(w2[8], w2[9], w2[10], w2[11]);
        w2[8] = this.X0;
        w2[9] = this.X1;
        w2[10] = this.X2;
        w2[11] = this.X3;
        this.sb0(w2[12], w2[13], w2[14], w2[15]);
        w2[12] = this.X0;
        w2[13] = this.X1;
        w2[14] = this.X2;
        w2[15] = this.X3;
        this.sb7(w2[16], w2[17], w2[18], w2[19]);
        w2[16] = this.X0;
        w2[17] = this.X1;
        w2[18] = this.X2;
        w2[19] = this.X3;
        this.sb6(w2[20], w2[21], w2[22], w2[23]);
        w2[20] = this.X0;
        w2[21] = this.X1;
        w2[22] = this.X2;
        w2[23] = this.X3;
        this.sb5(w2[24], w2[25], w2[26], w2[27]);
        w2[24] = this.X0;
        w2[25] = this.X1;
        w2[26] = this.X2;
        w2[27] = this.X3;
        this.sb4(w2[28], w2[29], w2[30], w2[31]);
        w2[28] = this.X0;
        w2[29] = this.X1;
        w2[30] = this.X2;
        w2[31] = this.X3;
        this.sb3(w2[32], w2[33], w2[34], w2[35]);
        w2[32] = this.X0;
        w2[33] = this.X1;
        w2[34] = this.X2;
        w2[35] = this.X3;
        this.sb2(w2[36], w2[37], w2[38], w2[39]);
        w2[36] = this.X0;
        w2[37] = this.X1;
        w2[38] = this.X2;
        w2[39] = this.X3;
        this.sb1(w2[40], w2[41], w2[42], w2[43]);
        w2[40] = this.X0;
        w2[41] = this.X1;
        w2[42] = this.X2;
        w2[43] = this.X3;
        this.sb0(w2[44], w2[45], w2[46], w2[47]);
        w2[44] = this.X0;
        w2[45] = this.X1;
        w2[46] = this.X2;
        w2[47] = this.X3;
        this.sb7(w2[48], w2[49], w2[50], w2[51]);
        w2[48] = this.X0;
        w2[49] = this.X1;
        w2[50] = this.X2;
        w2[51] = this.X3;
        this.sb6(w2[52], w2[53], w2[54], w2[55]);
        w2[52] = this.X0;
        w2[53] = this.X1;
        w2[54] = this.X2;
        w2[55] = this.X3;
        this.sb5(w2[56], w2[57], w2[58], w2[59]);
        w2[56] = this.X0;
        w2[57] = this.X1;
        w2[58] = this.X2;
        w2[59] = this.X3;
        this.sb4(w2[60], w2[61], w2[62], w2[63]);
        w2[60] = this.X0;
        w2[61] = this.X1;
        w2[62] = this.X2;
        w2[63] = this.X3;
        this.sb3(w2[64], w2[65], w2[66], w2[67]);
        w2[64] = this.X0;
        w2[65] = this.X1;
        w2[66] = this.X2;
        w2[67] = this.X3;
        this.sb2(w2[68], w2[69], w2[70], w2[71]);
        w2[68] = this.X0;
        w2[69] = this.X1;
        w2[70] = this.X2;
        w2[71] = this.X3;
        this.sb1(w2[72], w2[73], w2[74], w2[75]);
        w2[72] = this.X0;
        w2[73] = this.X1;
        w2[74] = this.X2;
        w2[75] = this.X3;
        this.sb0(w2[76], w2[77], w2[78], w2[79]);
        w2[76] = this.X0;
        w2[77] = this.X1;
        w2[78] = this.X2;
        w2[79] = this.X3;
        this.sb7(w2[80], w2[81], w2[82], w2[83]);
        w2[80] = this.X0;
        w2[81] = this.X1;
        w2[82] = this.X2;
        w2[83] = this.X3;
        this.sb6(w2[84], w2[85], w2[86], w2[87]);
        w2[84] = this.X0;
        w2[85] = this.X1;
        w2[86] = this.X2;
        w2[87] = this.X3;
        this.sb5(w2[88], w2[89], w2[90], w2[91]);
        w2[88] = this.X0;
        w2[89] = this.X1;
        w2[90] = this.X2;
        w2[91] = this.X3;
        this.sb4(w2[92], w2[93], w2[94], w2[95]);
        w2[92] = this.X0;
        w2[93] = this.X1;
        w2[94] = this.X2;
        w2[95] = this.X3;
        this.sb3(w2[96], w2[97], w2[98], w2[99]);
        w2[96] = this.X0;
        w2[97] = this.X1;
        w2[98] = this.X2;
        w2[99] = this.X3;
        this.sb2(w2[100], w2[101], w2[102], w2[103]);
        w2[100] = this.X0;
        w2[101] = this.X1;
        w2[102] = this.X2;
        w2[103] = this.X3;
        this.sb1(w2[104], w2[105], w2[106], w2[107]);
        w2[104] = this.X0;
        w2[105] = this.X1;
        w2[106] = this.X2;
        w2[107] = this.X3;
        this.sb0(w2[108], w2[109], w2[110], w2[111]);
        w2[108] = this.X0;
        w2[109] = this.X1;
        w2[110] = this.X2;
        w2[111] = this.X3;
        this.sb7(w2[112], w2[113], w2[114], w2[115]);
        w2[112] = this.X0;
        w2[113] = this.X1;
        w2[114] = this.X2;
        w2[115] = this.X3;
        this.sb6(w2[116], w2[117], w2[118], w2[119]);
        w2[116] = this.X0;
        w2[117] = this.X1;
        w2[118] = this.X2;
        w2[119] = this.X3;
        this.sb5(w2[120], w2[121], w2[122], w2[123]);
        w2[120] = this.X0;
        w2[121] = this.X1;
        w2[122] = this.X2;
        w2[123] = this.X3;
        this.sb4(w2[124], w2[125], w2[126], w2[127]);
        w2[124] = this.X0;
        w2[125] = this.X1;
        w2[126] = this.X2;
        w2[127] = this.X3;
        this.sb3(w2[128], w2[129], w2[130], w2[131]);
        w2[128] = this.X0;
        w2[129] = this.X1;
        w2[130] = this.X2;
        w2[131] = this.X3;
        return w2;
    }

    private int rotateLeft(int x2, int bits) {
        return x2 << bits | x2 >>> -bits;
    }

    private int rotateRight(int x2, int bits) {
        return x2 >>> bits | x2 << -bits;
    }

    private int bytesToWord(byte[] src, int srcOff) {
        return (src[srcOff] & 0xFF) << 24 | (src[srcOff + 1] & 0xFF) << 16 | (src[srcOff + 2] & 0xFF) << 8 | src[srcOff + 3] & 0xFF;
    }

    private void wordToBytes(int word, byte[] dst, int dstOff) {
        dst[dstOff + 3] = (byte)word;
        dst[dstOff + 2] = (byte)(word >>> 8);
        dst[dstOff + 1] = (byte)(word >>> 16);
        dst[dstOff] = word >> 24;
    }

    private void encryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        this.X3 = this.bytesToWord(in, inOff);
        this.X2 = this.bytesToWord(in, inOff + 4);
        this.X1 = this.bytesToWord(in, inOff + 8);
        this.X0 = this.bytesToWord(in, inOff + 12);
        this.sb0(this.wKey[0] ^ this.X0, this.wKey[1] ^ this.X1, this.wKey[2] ^ this.X2, this.wKey[3] ^ this.X3);
        this.LT();
        this.sb1(this.wKey[4] ^ this.X0, this.wKey[5] ^ this.X1, this.wKey[6] ^ this.X2, this.wKey[7] ^ this.X3);
        this.LT();
        this.sb2(this.wKey[8] ^ this.X0, this.wKey[9] ^ this.X1, this.wKey[10] ^ this.X2, this.wKey[11] ^ this.X3);
        this.LT();
        this.sb3(this.wKey[12] ^ this.X0, this.wKey[13] ^ this.X1, this.wKey[14] ^ this.X2, this.wKey[15] ^ this.X3);
        this.LT();
        this.sb4(this.wKey[16] ^ this.X0, this.wKey[17] ^ this.X1, this.wKey[18] ^ this.X2, this.wKey[19] ^ this.X3);
        this.LT();
        this.sb5(this.wKey[20] ^ this.X0, this.wKey[21] ^ this.X1, this.wKey[22] ^ this.X2, this.wKey[23] ^ this.X3);
        this.LT();
        this.sb6(this.wKey[24] ^ this.X0, this.wKey[25] ^ this.X1, this.wKey[26] ^ this.X2, this.wKey[27] ^ this.X3);
        this.LT();
        this.sb7(this.wKey[28] ^ this.X0, this.wKey[29] ^ this.X1, this.wKey[30] ^ this.X2, this.wKey[31] ^ this.X3);
        this.LT();
        this.sb0(this.wKey[32] ^ this.X0, this.wKey[33] ^ this.X1, this.wKey[34] ^ this.X2, this.wKey[35] ^ this.X3);
        this.LT();
        this.sb1(this.wKey[36] ^ this.X0, this.wKey[37] ^ this.X1, this.wKey[38] ^ this.X2, this.wKey[39] ^ this.X3);
        this.LT();
        this.sb2(this.wKey[40] ^ this.X0, this.wKey[41] ^ this.X1, this.wKey[42] ^ this.X2, this.wKey[43] ^ this.X3);
        this.LT();
        this.sb3(this.wKey[44] ^ this.X0, this.wKey[45] ^ this.X1, this.wKey[46] ^ this.X2, this.wKey[47] ^ this.X3);
        this.LT();
        this.sb4(this.wKey[48] ^ this.X0, this.wKey[49] ^ this.X1, this.wKey[50] ^ this.X2, this.wKey[51] ^ this.X3);
        this.LT();
        this.sb5(this.wKey[52] ^ this.X0, this.wKey[53] ^ this.X1, this.wKey[54] ^ this.X2, this.wKey[55] ^ this.X3);
        this.LT();
        this.sb6(this.wKey[56] ^ this.X0, this.wKey[57] ^ this.X1, this.wKey[58] ^ this.X2, this.wKey[59] ^ this.X3);
        this.LT();
        this.sb7(this.wKey[60] ^ this.X0, this.wKey[61] ^ this.X1, this.wKey[62] ^ this.X2, this.wKey[63] ^ this.X3);
        this.LT();
        this.sb0(this.wKey[64] ^ this.X0, this.wKey[65] ^ this.X1, this.wKey[66] ^ this.X2, this.wKey[67] ^ this.X3);
        this.LT();
        this.sb1(this.wKey[68] ^ this.X0, this.wKey[69] ^ this.X1, this.wKey[70] ^ this.X2, this.wKey[71] ^ this.X3);
        this.LT();
        this.sb2(this.wKey[72] ^ this.X0, this.wKey[73] ^ this.X1, this.wKey[74] ^ this.X2, this.wKey[75] ^ this.X3);
        this.LT();
        this.sb3(this.wKey[76] ^ this.X0, this.wKey[77] ^ this.X1, this.wKey[78] ^ this.X2, this.wKey[79] ^ this.X3);
        this.LT();
        this.sb4(this.wKey[80] ^ this.X0, this.wKey[81] ^ this.X1, this.wKey[82] ^ this.X2, this.wKey[83] ^ this.X3);
        this.LT();
        this.sb5(this.wKey[84] ^ this.X0, this.wKey[85] ^ this.X1, this.wKey[86] ^ this.X2, this.wKey[87] ^ this.X3);
        this.LT();
        this.sb6(this.wKey[88] ^ this.X0, this.wKey[89] ^ this.X1, this.wKey[90] ^ this.X2, this.wKey[91] ^ this.X3);
        this.LT();
        this.sb7(this.wKey[92] ^ this.X0, this.wKey[93] ^ this.X1, this.wKey[94] ^ this.X2, this.wKey[95] ^ this.X3);
        this.LT();
        this.sb0(this.wKey[96] ^ this.X0, this.wKey[97] ^ this.X1, this.wKey[98] ^ this.X2, this.wKey[99] ^ this.X3);
        this.LT();
        this.sb1(this.wKey[100] ^ this.X0, this.wKey[101] ^ this.X1, this.wKey[102] ^ this.X2, this.wKey[103] ^ this.X3);
        this.LT();
        this.sb2(this.wKey[104] ^ this.X0, this.wKey[105] ^ this.X1, this.wKey[106] ^ this.X2, this.wKey[107] ^ this.X3);
        this.LT();
        this.sb3(this.wKey[108] ^ this.X0, this.wKey[109] ^ this.X1, this.wKey[110] ^ this.X2, this.wKey[111] ^ this.X3);
        this.LT();
        this.sb4(this.wKey[112] ^ this.X0, this.wKey[113] ^ this.X1, this.wKey[114] ^ this.X2, this.wKey[115] ^ this.X3);
        this.LT();
        this.sb5(this.wKey[116] ^ this.X0, this.wKey[117] ^ this.X1, this.wKey[118] ^ this.X2, this.wKey[119] ^ this.X3);
        this.LT();
        this.sb6(this.wKey[120] ^ this.X0, this.wKey[121] ^ this.X1, this.wKey[122] ^ this.X2, this.wKey[123] ^ this.X3);
        this.LT();
        this.sb7(this.wKey[124] ^ this.X0, this.wKey[125] ^ this.X1, this.wKey[126] ^ this.X2, this.wKey[127] ^ this.X3);
        this.wordToBytes(this.wKey[131] ^ this.X3, out, outOff);
        this.wordToBytes(this.wKey[130] ^ this.X2, out, outOff + 4);
        this.wordToBytes(this.wKey[129] ^ this.X1, out, outOff + 8);
        this.wordToBytes(this.wKey[128] ^ this.X0, out, outOff + 12);
    }

    private void decryptBlock(byte[] in, int inOff, byte[] out, int outOff) {
        this.X3 = this.wKey[131] ^ this.bytesToWord(in, inOff);
        this.X2 = this.wKey[130] ^ this.bytesToWord(in, inOff + 4);
        this.X1 = this.wKey[129] ^ this.bytesToWord(in, inOff + 8);
        this.X0 = this.wKey[128] ^ this.bytesToWord(in, inOff + 12);
        this.ib7(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[124];
        this.X1 ^= this.wKey[125];
        this.X2 ^= this.wKey[126];
        this.X3 ^= this.wKey[127];
        this.inverseLT();
        this.ib6(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[120];
        this.X1 ^= this.wKey[121];
        this.X2 ^= this.wKey[122];
        this.X3 ^= this.wKey[123];
        this.inverseLT();
        this.ib5(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[116];
        this.X1 ^= this.wKey[117];
        this.X2 ^= this.wKey[118];
        this.X3 ^= this.wKey[119];
        this.inverseLT();
        this.ib4(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[112];
        this.X1 ^= this.wKey[113];
        this.X2 ^= this.wKey[114];
        this.X3 ^= this.wKey[115];
        this.inverseLT();
        this.ib3(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[108];
        this.X1 ^= this.wKey[109];
        this.X2 ^= this.wKey[110];
        this.X3 ^= this.wKey[111];
        this.inverseLT();
        this.ib2(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[104];
        this.X1 ^= this.wKey[105];
        this.X2 ^= this.wKey[106];
        this.X3 ^= this.wKey[107];
        this.inverseLT();
        this.ib1(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[100];
        this.X1 ^= this.wKey[101];
        this.X2 ^= this.wKey[102];
        this.X3 ^= this.wKey[103];
        this.inverseLT();
        this.ib0(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[96];
        this.X1 ^= this.wKey[97];
        this.X2 ^= this.wKey[98];
        this.X3 ^= this.wKey[99];
        this.inverseLT();
        this.ib7(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[92];
        this.X1 ^= this.wKey[93];
        this.X2 ^= this.wKey[94];
        this.X3 ^= this.wKey[95];
        this.inverseLT();
        this.ib6(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[88];
        this.X1 ^= this.wKey[89];
        this.X2 ^= this.wKey[90];
        this.X3 ^= this.wKey[91];
        this.inverseLT();
        this.ib5(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[84];
        this.X1 ^= this.wKey[85];
        this.X2 ^= this.wKey[86];
        this.X3 ^= this.wKey[87];
        this.inverseLT();
        this.ib4(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[80];
        this.X1 ^= this.wKey[81];
        this.X2 ^= this.wKey[82];
        this.X3 ^= this.wKey[83];
        this.inverseLT();
        this.ib3(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[76];
        this.X1 ^= this.wKey[77];
        this.X2 ^= this.wKey[78];
        this.X3 ^= this.wKey[79];
        this.inverseLT();
        this.ib2(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[72];
        this.X1 ^= this.wKey[73];
        this.X2 ^= this.wKey[74];
        this.X3 ^= this.wKey[75];
        this.inverseLT();
        this.ib1(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[68];
        this.X1 ^= this.wKey[69];
        this.X2 ^= this.wKey[70];
        this.X3 ^= this.wKey[71];
        this.inverseLT();
        this.ib0(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[64];
        this.X1 ^= this.wKey[65];
        this.X2 ^= this.wKey[66];
        this.X3 ^= this.wKey[67];
        this.inverseLT();
        this.ib7(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[60];
        this.X1 ^= this.wKey[61];
        this.X2 ^= this.wKey[62];
        this.X3 ^= this.wKey[63];
        this.inverseLT();
        this.ib6(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[56];
        this.X1 ^= this.wKey[57];
        this.X2 ^= this.wKey[58];
        this.X3 ^= this.wKey[59];
        this.inverseLT();
        this.ib5(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[52];
        this.X1 ^= this.wKey[53];
        this.X2 ^= this.wKey[54];
        this.X3 ^= this.wKey[55];
        this.inverseLT();
        this.ib4(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[48];
        this.X1 ^= this.wKey[49];
        this.X2 ^= this.wKey[50];
        this.X3 ^= this.wKey[51];
        this.inverseLT();
        this.ib3(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[44];
        this.X1 ^= this.wKey[45];
        this.X2 ^= this.wKey[46];
        this.X3 ^= this.wKey[47];
        this.inverseLT();
        this.ib2(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[40];
        this.X1 ^= this.wKey[41];
        this.X2 ^= this.wKey[42];
        this.X3 ^= this.wKey[43];
        this.inverseLT();
        this.ib1(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[36];
        this.X1 ^= this.wKey[37];
        this.X2 ^= this.wKey[38];
        this.X3 ^= this.wKey[39];
        this.inverseLT();
        this.ib0(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[32];
        this.X1 ^= this.wKey[33];
        this.X2 ^= this.wKey[34];
        this.X3 ^= this.wKey[35];
        this.inverseLT();
        this.ib7(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[28];
        this.X1 ^= this.wKey[29];
        this.X2 ^= this.wKey[30];
        this.X3 ^= this.wKey[31];
        this.inverseLT();
        this.ib6(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[24];
        this.X1 ^= this.wKey[25];
        this.X2 ^= this.wKey[26];
        this.X3 ^= this.wKey[27];
        this.inverseLT();
        this.ib5(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[20];
        this.X1 ^= this.wKey[21];
        this.X2 ^= this.wKey[22];
        this.X3 ^= this.wKey[23];
        this.inverseLT();
        this.ib4(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[16];
        this.X1 ^= this.wKey[17];
        this.X2 ^= this.wKey[18];
        this.X3 ^= this.wKey[19];
        this.inverseLT();
        this.ib3(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[12];
        this.X1 ^= this.wKey[13];
        this.X2 ^= this.wKey[14];
        this.X3 ^= this.wKey[15];
        this.inverseLT();
        this.ib2(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[8];
        this.X1 ^= this.wKey[9];
        this.X2 ^= this.wKey[10];
        this.X3 ^= this.wKey[11];
        this.inverseLT();
        this.ib1(this.X0, this.X1, this.X2, this.X3);
        this.X0 ^= this.wKey[4];
        this.X1 ^= this.wKey[5];
        this.X2 ^= this.wKey[6];
        this.X3 ^= this.wKey[7];
        this.inverseLT();
        this.ib0(this.X0, this.X1, this.X2, this.X3);
        this.wordToBytes(this.X3 ^ this.wKey[3], out, outOff);
        this.wordToBytes(this.X2 ^ this.wKey[2], out, outOff + 4);
        this.wordToBytes(this.X1 ^ this.wKey[1], out, outOff + 8);
        this.wordToBytes(this.X0 ^ this.wKey[0], out, outOff + 12);
    }

    private void sb0(int a2, int b2, int c2, int d2) {
        int t1 = a2 ^ d2;
        int t3 = c2 ^ t1;
        int t4 = b2 ^ t3;
        this.X3 = a2 & d2 ^ t4;
        int t7 = a2 ^ b2 & t1;
        this.X2 = t4 ^ (c2 | t7);
        int t12 = this.X3 & (t3 ^ t7);
        this.X1 = ~t3 ^ t12;
        this.X0 = t12 ^ ~t7;
    }

    private void ib0(int a2, int b2, int c2, int d2) {
        int t1 = ~a2;
        int t2 = a2 ^ b2;
        int t4 = d2 ^ (t1 | t2);
        int t5 = c2 ^ t4;
        this.X2 = t2 ^ t5;
        int t8 = t1 ^ d2 & t2;
        this.X1 = t4 ^ this.X2 & t8;
        this.X3 = a2 & t4 ^ (t5 | this.X1);
        this.X0 = this.X3 ^ (t5 ^ t8);
    }

    private void sb1(int a2, int b2, int c2, int d2) {
        int t2 = b2 ^ ~a2;
        int t5 = c2 ^ (a2 | t2);
        this.X2 = d2 ^ t5;
        int t7 = b2 ^ (d2 | t2);
        int t8 = t2 ^ this.X2;
        this.X3 = t8 ^ t5 & t7;
        int t11 = t5 ^ t7;
        this.X1 = this.X3 ^ t11;
        this.X0 = t5 ^ t8 & t11;
    }

    private void ib1(int a2, int b2, int c2, int d2) {
        int t1 = b2 ^ d2;
        int t3 = a2 ^ b2 & t1;
        int t4 = t1 ^ t3;
        this.X3 = c2 ^ t4;
        int t7 = b2 ^ t1 & t3;
        int t8 = this.X3 | t7;
        this.X1 = t3 ^ t8;
        int t10 = ~this.X1;
        int t11 = this.X3 ^ t7;
        this.X0 = t10 ^ t11;
        this.X2 = t4 ^ (t10 | t11);
    }

    private void sb2(int a2, int b2, int c2, int d2) {
        int t1 = ~a2;
        int t2 = b2 ^ d2;
        int t3 = c2 & t1;
        this.X0 = t2 ^ t3;
        int t5 = c2 ^ t1;
        int t6 = c2 ^ this.X0;
        int t7 = b2 & t6;
        this.X3 = t5 ^ t7;
        this.X2 = a2 ^ (d2 | t7) & (this.X0 | t5);
        this.X1 = t2 ^ this.X3 ^ (this.X2 ^ (d2 | t1));
    }

    private void ib2(int a2, int b2, int c2, int d2) {
        int t1 = b2 ^ d2;
        int t2 = ~t1;
        int t3 = a2 ^ c2;
        int t4 = c2 ^ t1;
        int t5 = b2 & t4;
        this.X0 = t3 ^ t5;
        int t7 = a2 | t2;
        int t8 = d2 ^ t7;
        int t9 = t3 | t8;
        this.X3 = t1 ^ t9;
        int t11 = ~t4;
        int t12 = this.X0 | this.X3;
        this.X1 = t11 ^ t12;
        this.X2 = d2 & t11 ^ (t3 ^ t12);
    }

    private void sb3(int a2, int b2, int c2, int d2) {
        int t1 = a2 ^ b2;
        int t2 = a2 & c2;
        int t3 = a2 | d2;
        int t4 = c2 ^ d2;
        int t5 = t1 & t3;
        int t6 = t2 | t5;
        this.X2 = t4 ^ t6;
        int t8 = b2 ^ t3;
        int t9 = t6 ^ t8;
        int t10 = t4 & t9;
        this.X0 = t1 ^ t10;
        int t12 = this.X2 & this.X0;
        this.X1 = t9 ^ t12;
        this.X3 = (b2 | d2) ^ (t4 ^ t12);
    }

    private void ib3(int a2, int b2, int c2, int d2) {
        int t1 = a2 | b2;
        int t2 = b2 ^ c2;
        int t3 = b2 & t2;
        int t4 = a2 ^ t3;
        int t5 = c2 ^ t4;
        int t6 = d2 | t4;
        this.X0 = t2 ^ t6;
        int t8 = t2 | t6;
        int t9 = d2 ^ t8;
        this.X2 = t5 ^ t9;
        int t11 = t1 ^ t9;
        int t12 = this.X0 & t11;
        this.X3 = t4 ^ t12;
        this.X1 = this.X3 ^ (this.X0 ^ t11);
    }

    private void sb4(int a2, int b2, int c2, int d2) {
        int t1 = a2 ^ d2;
        int t2 = d2 & t1;
        int t3 = c2 ^ t2;
        int t4 = b2 | t3;
        this.X3 = t1 ^ t4;
        int t6 = ~b2;
        int t7 = t1 | t6;
        this.X0 = t3 ^ t7;
        int t9 = a2 & this.X0;
        int t10 = t1 ^ t6;
        int t11 = t4 & t10;
        this.X2 = t9 ^ t11;
        this.X1 = a2 ^ t3 ^ t10 & this.X2;
    }

    private void ib4(int a2, int b2, int c2, int d2) {
        int t1 = c2 | d2;
        int t2 = a2 & t1;
        int t3 = b2 ^ t2;
        int t4 = a2 & t3;
        int t5 = c2 ^ t4;
        this.X1 = d2 ^ t5;
        int t7 = ~a2;
        int t8 = t5 & this.X1;
        this.X3 = t3 ^ t8;
        int t10 = this.X1 | t7;
        int t11 = d2 ^ t10;
        this.X0 = this.X3 ^ t11;
        this.X2 = t3 & t11 ^ (this.X1 ^ t7);
    }

    private void sb5(int a2, int b2, int c2, int d2) {
        int t1 = ~a2;
        int t2 = a2 ^ b2;
        int t3 = a2 ^ d2;
        int t4 = c2 ^ t1;
        int t5 = t2 | t3;
        this.X0 = t4 ^ t5;
        int t7 = d2 & this.X0;
        int t8 = t2 ^ this.X0;
        this.X1 = t7 ^ t8;
        int t10 = t1 | this.X0;
        int t11 = t2 | t7;
        int t12 = t3 ^ t10;
        this.X2 = t11 ^ t12;
        this.X3 = b2 ^ t7 ^ this.X1 & t12;
    }

    private void ib5(int a2, int b2, int c2, int d2) {
        int t1 = ~c2;
        int t2 = b2 & t1;
        int t3 = d2 ^ t2;
        int t4 = a2 & t3;
        int t5 = b2 ^ t1;
        this.X3 = t4 ^ t5;
        int t7 = b2 | this.X3;
        int t8 = a2 & t7;
        this.X1 = t3 ^ t8;
        int t10 = a2 | d2;
        int t11 = t1 ^ t7;
        this.X0 = t10 ^ t11;
        this.X2 = b2 & t10 ^ (t4 | a2 ^ c2);
    }

    private void sb6(int a2, int b2, int c2, int d2) {
        int t1 = ~a2;
        int t2 = a2 ^ d2;
        int t3 = b2 ^ t2;
        int t4 = t1 | t2;
        int t5 = c2 ^ t4;
        this.X1 = b2 ^ t5;
        int t7 = t2 | this.X1;
        int t8 = d2 ^ t7;
        int t9 = t5 & t8;
        this.X2 = t3 ^ t9;
        int t11 = t5 ^ t8;
        this.X0 = this.X2 ^ t11;
        this.X3 = ~t5 ^ t3 & t11;
    }

    private void ib6(int a2, int b2, int c2, int d2) {
        int t1 = ~a2;
        int t2 = a2 ^ b2;
        int t3 = c2 ^ t2;
        int t4 = c2 | t1;
        int t5 = d2 ^ t4;
        this.X1 = t3 ^ t5;
        int t7 = t3 & t5;
        int t8 = t2 ^ t7;
        int t9 = b2 | t8;
        this.X3 = t5 ^ t9;
        int t11 = b2 | this.X3;
        this.X0 = t8 ^ t11;
        this.X2 = d2 & t1 ^ (t3 ^ t11);
    }

    private void sb7(int a2, int b2, int c2, int d2) {
        int t1 = b2 ^ c2;
        int t2 = c2 & t1;
        int t3 = d2 ^ t2;
        int t4 = a2 ^ t3;
        int t5 = d2 | t1;
        int t6 = t4 & t5;
        this.X1 = b2 ^ t6;
        int t8 = t3 | this.X1;
        int t9 = a2 & t4;
        this.X3 = t1 ^ t9;
        int t11 = t4 ^ t8;
        int t12 = this.X3 & t11;
        this.X2 = t3 ^ t12;
        this.X0 = ~t11 ^ this.X3 & this.X2;
    }

    private void ib7(int a2, int b2, int c2, int d2) {
        int t3 = c2 | a2 & b2;
        int t4 = d2 & (a2 | b2);
        this.X3 = t3 ^ t4;
        int t6 = ~d2;
        int t7 = b2 ^ t4;
        int t9 = t7 | this.X3 ^ t6;
        this.X1 = a2 ^ t9;
        this.X0 = c2 ^ t7 ^ (d2 | this.X1);
        this.X2 = t3 ^ this.X1 ^ (this.X0 ^ a2 & this.X3);
    }

    private void LT() {
        int x0 = this.rotateLeft(this.X0, 13);
        int x2 = this.rotateLeft(this.X2, 3);
        int x1 = this.X1 ^ x0 ^ x2;
        int x3 = this.X3 ^ x2 ^ x0 << 3;
        this.X1 = this.rotateLeft(x1, 1);
        this.X3 = this.rotateLeft(x3, 7);
        this.X0 = this.rotateLeft(x0 ^ this.X1 ^ this.X3, 5);
        this.X2 = this.rotateLeft(x2 ^ this.X3 ^ this.X1 << 7, 22);
    }

    private void inverseLT() {
        int x2 = this.rotateRight(this.X2, 22) ^ this.X3 ^ this.X1 << 7;
        int x0 = this.rotateRight(this.X0, 5) ^ this.X1 ^ this.X3;
        int x3 = this.rotateRight(this.X3, 7);
        int x1 = this.rotateRight(this.X1, 1);
        this.X3 = x3 ^ x2 ^ x0 << 3;
        this.X1 = x1 ^ x0 ^ x2;
        this.X2 = this.rotateRight(x2, 3);
        this.X0 = this.rotateRight(x0, 13);
    }
}

