/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

public class X509NameTokenizer {
    private String value;
    private int index;
    private char separator;
    private StringBuffer buf = new StringBuffer();

    public X509NameTokenizer(String oid) {
        this(oid, ',');
    }

    public X509NameTokenizer(String oid, char separator) {
        this.value = oid;
        this.index = -1;
        this.separator = separator;
    }

    public boolean hasMoreTokens() {
        return this.index != this.value.length();
    }

    public String nextToken() {
        int end;
        if (this.index == this.value.length()) {
            return null;
        }
        boolean quoted = false;
        boolean escaped = false;
        this.buf.setLength(0);
        for (end = this.index + 1; end != this.value.length(); ++end) {
            char c2 = this.value.charAt(end);
            if (c2 == '\"') {
                if (!escaped) {
                    quoted = !quoted;
                } else {
                    if (c2 == '#' && this.buf.charAt(this.buf.length() - 1) == '=') {
                        this.buf.append('\\');
                    } else if (c2 == '+' && this.separator != '+') {
                        this.buf.append('\\');
                    }
                    this.buf.append(c2);
                }
                escaped = false;
                continue;
            }
            if (escaped || quoted) {
                if (c2 == '#' && this.buf.charAt(this.buf.length() - 1) == '=') {
                    this.buf.append('\\');
                } else if (c2 == '+' && this.separator != '+') {
                    this.buf.append('\\');
                }
                this.buf.append(c2);
                escaped = false;
                continue;
            }
            if (c2 == '\\') {
                escaped = true;
                continue;
            }
            if (c2 == this.separator) break;
            this.buf.append(c2);
        }
        this.index = end;
        return this.buf.toString().trim();
    }
}

