/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.tsp;

import cfca.sadk.algorithm.common.PKCSObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.ASN1Boolean;
import cfca.sadk.org.bouncycastle.asn1.ASN1GeneralizedTime;
import cfca.sadk.org.bouncycastle.asn1.ASN1Integer;
import cfca.sadk.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import cfca.sadk.org.bouncycastle.asn1.DERNull;
import cfca.sadk.org.bouncycastle.asn1.cms.AttributeTable;
import cfca.sadk.org.bouncycastle.asn1.ess.ESSCertID;
import cfca.sadk.org.bouncycastle.asn1.ess.ESSCertIDv2;
import cfca.sadk.org.bouncycastle.asn1.ess.SigningCertificate;
import cfca.sadk.org.bouncycastle.asn1.ess.SigningCertificateV2;
import cfca.sadk.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import cfca.sadk.org.bouncycastle.asn1.tsp.Accuracy;
import cfca.sadk.org.bouncycastle.asn1.tsp.MessageImprint;
import cfca.sadk.org.bouncycastle.asn1.tsp.TSTInfo;
import cfca.sadk.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import cfca.sadk.org.bouncycastle.asn1.x509.Certificate;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralName;
import cfca.sadk.org.bouncycastle.asn1.x509.GeneralNames;
import cfca.sadk.org.bouncycastle.asn1.x509.IssuerSerial;
import cfca.sadk.org.bouncycastle.cert.X509CertificateHolder;
import cfca.sadk.org.bouncycastle.cms.CMSAttributeTableGenerationException;
import cfca.sadk.org.bouncycastle.cms.CMSAttributeTableGenerator;
import cfca.sadk.org.bouncycastle.cms.CMSException;
import cfca.sadk.org.bouncycastle.cms.CMSProcessableByteArray;
import cfca.sadk.org.bouncycastle.cms.CMSSM2SignedDataGenerator;
import cfca.sadk.org.bouncycastle.cms.CMSSignedData;
import cfca.sadk.org.bouncycastle.cms.CMSSignedDataGenerator;
import cfca.sadk.org.bouncycastle.cms.SignerInfoGenerator;
import cfca.sadk.org.bouncycastle.operator.DigestCalculator;
import cfca.sadk.org.bouncycastle.tsp.TSPException;
import cfca.sadk.org.bouncycastle.tsp.TSPUtil;
import cfca.sadk.org.bouncycastle.tsp.TimeStampRequest;
import cfca.sadk.org.bouncycastle.tsp.TimeStampToken;
import cfca.sadk.org.bouncycastle.util.CollectionStore;
import cfca.sadk.org.bouncycastle.util.Store;
import cfca.sadk.util.CertUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TimeStampTokenGenerator {
    int accuracySeconds = -1;
    int accuracyMillis = -1;
    int accuracyMicros = -1;
    boolean ordering = false;
    GeneralName tsa = null;
    private ASN1ObjectIdentifier tsaPolicyOID;
    private List certs = new ArrayList();
    private List crls = new ArrayList();
    private List attrCerts = new ArrayList();
    private Map otherRevoc = new HashMap();
    private SignerInfoGenerator signerInfoGen;

    public TimeStampTokenGenerator(SignerInfoGenerator signerInfoGen, DigestCalculator digestCalculator, ASN1ObjectIdentifier tsaPolicy) throws IllegalArgumentException, TSPException {
        this(signerInfoGen, digestCalculator, tsaPolicy, false);
    }

    public TimeStampTokenGenerator(final SignerInfoGenerator signerInfoGen, ASN1ObjectIdentifier tsaPolicy) throws IllegalArgumentException, TSPException {
        this.signerInfoGen = signerInfoGen;
        this.tsaPolicyOID = tsaPolicy;
        if (!signerInfoGen.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("SignerInfoGenerator must have an associated certificate");
        }
        TSPUtil.validateCertificate(signerInfoGen.getAssociatedCertificate());
        try {
            final ESSCertID essCertid = new ESSCertID(MessageDigest.getInstance("SHA-1").digest(signerInfoGen.getAssociatedCertificate().getEncoded()));
            this.signerInfoGen = new SignerInfoGenerator(signerInfoGen, new CMSAttributeTableGenerator(){

                public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                    AttributeTable table = signerInfoGen.getSignedAttributeTableGenerator().getAttributes(parameters);
                    return table.add(cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers.id_aa_signingCertificate, new SigningCertificate(essCertid));
                }
            }, signerInfoGen.getUnsignedAttributeTableGenerator());
        }
        catch (NoSuchAlgorithmException e) {
            throw new TSPException("Can't find a SHA-1 implementation.", e);
        }
        catch (IOException e) {
            throw new TSPException("Exception processing certificate.", e);
        }
    }

    public TimeStampTokenGenerator(final SignerInfoGenerator signerInfoGen, DigestCalculator digestCalculator, ASN1ObjectIdentifier tsaPolicy, boolean isIssuerSerialIncluded) throws IllegalArgumentException, TSPException {
        this.signerInfoGen = signerInfoGen;
        this.tsaPolicyOID = tsaPolicy;
        if (!signerInfoGen.hasAssociatedCertificate()) {
            throw new IllegalArgumentException("SignerInfoGenerator must have an associated certificate");
        }
        X509CertificateHolder assocCert = signerInfoGen.getAssociatedCertificate();
        TSPUtil.validateCertificate(assocCert);
        try {
            OutputStream dOut = digestCalculator.getOutputStream();
            dOut.write(assocCert.getEncoded());
            dOut.close();
            if (digestCalculator.getAlgorithmIdentifier().getAlgorithm().equals(OIWObjectIdentifiers.idSHA1)) {
                final ESSCertID essCertid = new ESSCertID(digestCalculator.getDigest(), isIssuerSerialIncluded ? new IssuerSerial(new GeneralNames(new GeneralName(assocCert.getIssuer())), assocCert.getSerialNumber()) : null);
                this.signerInfoGen = new SignerInfoGenerator(signerInfoGen, new CMSAttributeTableGenerator(){

                    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                        AttributeTable table = signerInfoGen.getSignedAttributeTableGenerator().getAttributes(parameters);
                        if (table.get(cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers.id_aa_signingCertificate) == null) {
                            return table.add(cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers.id_aa_signingCertificate, new SigningCertificate(essCertid));
                        }
                        return table;
                    }
                }, signerInfoGen.getUnsignedAttributeTableGenerator());
            } else {
                AlgorithmIdentifier digAlgID = new AlgorithmIdentifier(digestCalculator.getAlgorithmIdentifier().getAlgorithm());
                final ESSCertIDv2 essCertid = new ESSCertIDv2(digAlgID, digestCalculator.getDigest(), isIssuerSerialIncluded ? new IssuerSerial(new GeneralNames(new GeneralName(assocCert.getIssuer())), new ASN1Integer(assocCert.getSerialNumber())) : null);
                this.signerInfoGen = new SignerInfoGenerator(signerInfoGen, new CMSAttributeTableGenerator(){

                    public AttributeTable getAttributes(Map parameters) throws CMSAttributeTableGenerationException {
                        AttributeTable table = signerInfoGen.getSignedAttributeTableGenerator().getAttributes(parameters);
                        if (table.get(cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers.id_aa_signingCertificateV2) == null) {
                            return table.add(cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers.id_aa_signingCertificateV2, new SigningCertificateV2(essCertid));
                        }
                        return table;
                    }
                }, signerInfoGen.getUnsignedAttributeTableGenerator());
            }
        }
        catch (IOException e) {
            throw new TSPException("Exception processing certificate.", e);
        }
    }

    public void addCertificates(Store certStore) {
        this.certs.addAll(certStore.getMatches(null));
    }

    public void addCRLs(Store crlStore) {
        this.crls.addAll(crlStore.getMatches(null));
    }

    public void addAttributeCertificates(Store attrStore) {
        this.attrCerts.addAll(attrStore.getMatches(null));
    }

    public void addOtherRevocationInfo(ASN1ObjectIdentifier otherRevocationInfoFormat, Store otherRevocationInfos) {
        this.otherRevoc.put(otherRevocationInfoFormat, otherRevocationInfos.getMatches(null));
    }

    public void setAccuracySeconds(int accuracySeconds) {
        this.accuracySeconds = accuracySeconds;
    }

    public void setAccuracyMillis(int accuracyMillis) {
        this.accuracyMillis = accuracyMillis;
    }

    public void setAccuracyMicros(int accuracyMicros) {
        this.accuracyMicros = accuracyMicros;
    }

    public void setOrdering(boolean ordering) {
        this.ordering = ordering;
    }

    public void setTSA(GeneralName tsa) {
        this.tsa = tsa;
    }

    public TimeStampToken generate(TimeStampRequest request, BigInteger serialNumber, Date genTime) throws TSPException {
        ASN1ObjectIdentifier digestAlgOID = request.getMessageImprintAlgOID();
        AlgorithmIdentifier algID = new AlgorithmIdentifier(digestAlgOID, DERNull.INSTANCE);
        X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)this.certs.get(0);
        Certificate certificate = x509CertificateHolder.toASN1Structure();
        X509Cert x509Cert = new X509Cert(certificate);
        if (CertUtil.isSM2Cert(x509Cert) ? !algID.getAlgorithm().equals(PKCSObjectIdentifiers.sm3) : algID.getAlgorithm().equals(PKCSObjectIdentifiers.sm3)) {
            throw new TSPException("Bad request digest algorithm!");
        }
        MessageImprint messageImprint = new MessageImprint(algID, request.getMessageImprintDigest());
        Accuracy accuracy = null;
        if (this.accuracySeconds > 0 || this.accuracyMillis > 0 || this.accuracyMicros > 0) {
            ASN1Integer seconds = null;
            if (this.accuracySeconds > 0) {
                seconds = new ASN1Integer(this.accuracySeconds);
            }
            ASN1Integer millis = null;
            if (this.accuracyMillis > 0) {
                millis = new ASN1Integer(this.accuracyMillis);
            }
            ASN1Integer micros = null;
            if (this.accuracyMicros > 0) {
                micros = new ASN1Integer(this.accuracyMicros);
            }
            accuracy = new Accuracy(seconds, millis, micros);
        }
        ASN1Boolean derOrdering = null;
        if (this.ordering) {
            derOrdering = new ASN1Boolean(this.ordering);
        }
        ASN1Integer nonce = null;
        if (request.getNonce() != null) {
            nonce = new ASN1Integer(request.getNonce());
        }
        ASN1ObjectIdentifier tsaPolicy = this.tsaPolicyOID;
        if (request.getReqPolicy() != null) {
            tsaPolicy = request.getReqPolicy();
        }
        TSTInfo tstInfo = new TSTInfo(tsaPolicy, messageImprint, new ASN1Integer(serialNumber), new ASN1GeneralizedTime(genTime), accuracy, derOrdering, nonce, this.tsa, request.getExtensions());
        try {
            CMSSignedData signedData = null;
            if (!algID.getAlgorithm().equals(PKCSObjectIdentifiers.sm3)) {
                CMSSignedDataGenerator signedDataGenerator = new CMSSignedDataGenerator();
                if (request.getCertReq()) {
                    signedDataGenerator.addCertificates(new CollectionStore(this.certs));
                    signedDataGenerator.addAttributeCertificates(new CollectionStore(this.attrCerts));
                }
                signedDataGenerator.addCRLs(new CollectionStore(this.crls));
                if (!this.otherRevoc.isEmpty()) {
                    Iterator it = this.otherRevoc.keySet().iterator();
                    while (it.hasNext()) {
                        ASN1ObjectIdentifier format = (ASN1ObjectIdentifier)it.next();
                        signedDataGenerator.addOtherRevocationInfo(format, new CollectionStore((Collection)this.otherRevoc.get(format)));
                    }
                }
                signedDataGenerator.addSignerInfoGenerator(this.signerInfoGen);
                byte[] derEncodedTSTInfo = tstInfo.getEncoded("DER");
                signedData = signedDataGenerator.generate(new CMSProcessableByteArray(cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers.id_ct_TSTInfo, derEncodedTSTInfo), true);
            } else {
                CMSSM2SignedDataGenerator signedDataGenerator = new CMSSM2SignedDataGenerator();
                if (request.getCertReq()) {
                    signedDataGenerator.addCertificates(new CollectionStore(this.certs));
                    signedDataGenerator.addAttributeCertificates(new CollectionStore(this.attrCerts));
                }
                signedDataGenerator.addCRLs(new CollectionStore(this.crls));
                if (!this.otherRevoc.isEmpty()) {
                    Iterator it = this.otherRevoc.keySet().iterator();
                    while (it.hasNext()) {
                        ASN1ObjectIdentifier format = (ASN1ObjectIdentifier)it.next();
                        signedDataGenerator.addOtherRevocationInfo(format, new CollectionStore((Collection)this.otherRevoc.get(format)));
                    }
                }
                signedDataGenerator.addSignerInfoGenerator(this.signerInfoGen);
                byte[] derEncodedTSTInfo = tstInfo.getEncoded("DER");
                signedData = signedDataGenerator.generate(new CMSProcessableByteArray(cfca.sadk.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers.id_ct_TSTInfo, derEncodedTSTInfo), true);
            }
            return new TimeStampToken(signedData);
        }
        catch (CMSException cmsEx) {
            throw new TSPException("Error generating time-stamp token", cmsEx);
        }
        catch (IOException e) {
            throw new TSPException("Exception encoding info", e);
        }
    }
}

