/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cmp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Choice;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CAKeyUpdAnnContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CMPCertificate;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CRLAnnContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CertConfirmContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.CertRepMessage;
import com.timevale.tgtext.bouncycastle.asn1.cmp.ErrorMsgContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.GenMsgContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.GenRepContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.KeyRecRepContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIConfirmContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIMessages;
import com.timevale.tgtext.bouncycastle.asn1.cmp.POPODecKeyChallContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.POPODecKeyRespContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PollRepContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PollReqContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.RevAnnContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.RevRepContent;
import com.timevale.tgtext.bouncycastle.asn1.cmp.RevReqContent;
import com.timevale.tgtext.bouncycastle.asn1.crmf.CertReqMessages;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.CertificationRequest;

public class PKIBody
extends ASN1Object
implements ASN1Choice {
    public static final int TYPE_INIT_REQ = 0;
    public static final int TYPE_INIT_REP = 1;
    public static final int TYPE_CERT_REQ = 2;
    public static final int TYPE_CERT_REP = 3;
    public static final int TYPE_P10_CERT_REQ = 4;
    public static final int TYPE_POPO_CHALL = 5;
    public static final int TYPE_POPO_REP = 6;
    public static final int TYPE_KEY_UPDATE_REQ = 7;
    public static final int TYPE_KEY_UPDATE_REP = 8;
    public static final int TYPE_KEY_RECOVERY_REQ = 9;
    public static final int TYPE_KEY_RECOVERY_REP = 10;
    public static final int TYPE_REVOCATION_REQ = 11;
    public static final int TYPE_REVOCATION_REP = 12;
    public static final int TYPE_CROSS_CERT_REQ = 13;
    public static final int TYPE_CROSS_CERT_REP = 14;
    public static final int TYPE_CA_KEY_UPDATE_ANN = 15;
    public static final int TYPE_CERT_ANN = 16;
    public static final int TYPE_REVOCATION_ANN = 17;
    public static final int TYPE_CRL_ANN = 18;
    public static final int TYPE_CONFIRM = 19;
    public static final int TYPE_NESTED = 20;
    public static final int TYPE_GEN_MSG = 21;
    public static final int TYPE_GEN_REP = 22;
    public static final int TYPE_ERROR = 23;
    public static final int TYPE_CERT_CONFIRM = 24;
    public static final int TYPE_POLL_REQ = 25;
    public static final int TYPE_POLL_REP = 26;
    private int tagNo;
    private ASN1Encodable body;

    public static PKIBody getInstance(Object o2) {
        if (o2 == null || o2 instanceof PKIBody) {
            return (PKIBody)o2;
        }
        if (o2 instanceof ASN1TaggedObject) {
            return new PKIBody((ASN1TaggedObject)o2);
        }
        throw new IllegalArgumentException("Invalid object: " + o2.getClass().getName());
    }

    private PKIBody(ASN1TaggedObject tagged) {
        this.tagNo = tagged.getTagNo();
        this.body = PKIBody.getBodyForType(this.tagNo, tagged.getObject());
    }

    public PKIBody(int type, ASN1Encodable content) {
        this.tagNo = type;
        this.body = PKIBody.getBodyForType(type, content);
    }

    private static ASN1Encodable getBodyForType(int type, ASN1Encodable o2) {
        switch (type) {
            case 0: {
                return CertReqMessages.getInstance(o2);
            }
            case 1: {
                return CertRepMessage.getInstance(o2);
            }
            case 2: {
                return CertReqMessages.getInstance(o2);
            }
            case 3: {
                return CertRepMessage.getInstance(o2);
            }
            case 4: {
                return CertificationRequest.getInstance(o2);
            }
            case 5: {
                return POPODecKeyChallContent.getInstance(o2);
            }
            case 6: {
                return POPODecKeyRespContent.getInstance(o2);
            }
            case 7: {
                return CertReqMessages.getInstance(o2);
            }
            case 8: {
                return CertRepMessage.getInstance(o2);
            }
            case 9: {
                return CertReqMessages.getInstance(o2);
            }
            case 10: {
                return KeyRecRepContent.getInstance(o2);
            }
            case 11: {
                return RevReqContent.getInstance(o2);
            }
            case 12: {
                return RevRepContent.getInstance(o2);
            }
            case 13: {
                return CertReqMessages.getInstance(o2);
            }
            case 14: {
                return CertRepMessage.getInstance(o2);
            }
            case 15: {
                return CAKeyUpdAnnContent.getInstance(o2);
            }
            case 16: {
                return CMPCertificate.getInstance(o2);
            }
            case 17: {
                return RevAnnContent.getInstance(o2);
            }
            case 18: {
                return CRLAnnContent.getInstance(o2);
            }
            case 19: {
                return PKIConfirmContent.getInstance(o2);
            }
            case 20: {
                return PKIMessages.getInstance(o2);
            }
            case 21: {
                return GenMsgContent.getInstance(o2);
            }
            case 22: {
                return GenRepContent.getInstance(o2);
            }
            case 23: {
                return ErrorMsgContent.getInstance(o2);
            }
            case 24: {
                return CertConfirmContent.getInstance(o2);
            }
            case 25: {
                return PollReqContent.getInstance(o2);
            }
            case 26: {
                return PollRepContent.getInstance(o2);
            }
        }
        throw new IllegalArgumentException("unknown tag number: " + type);
    }

    public int getType() {
        return this.tagNo;
    }

    public ASN1Encodable getContent() {
        return this.body;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(true, this.tagNo, this.body);
    }
}

