/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.cms;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Set;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.DERTaggedObject;

public class OriginatorInfo
extends ASN1Object {
    private ASN1Set certs;
    private ASN1Set crls;

    public OriginatorInfo(ASN1Set certs, ASN1Set crls) {
        this.certs = certs;
        this.crls = crls;
    }

    private OriginatorInfo(ASN1Sequence seq) {
        switch (seq.size()) {
            case 0: {
                return;
            }
            case 1: {
                ASN1TaggedObject o2 = (ASN1TaggedObject)seq.getObjectAt(0);
                switch (o2.getTagNo()) {
                    case 0: {
                        this.certs = ASN1Set.getInstance(o2, false);
                        return;
                    }
                    case 1: {
                        this.crls = ASN1Set.getInstance(o2, false);
                        return;
                    }
                }
                throw new IllegalArgumentException("Bad tag in OriginatorInfo: " + o2.getTagNo());
            }
            case 2: {
                this.certs = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(0), false);
                this.crls = ASN1Set.getInstance((ASN1TaggedObject)seq.getObjectAt(1), false);
                return;
            }
        }
        throw new IllegalArgumentException("OriginatorInfo too big");
    }

    public static OriginatorInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return OriginatorInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static OriginatorInfo getInstance(Object obj) {
        if (obj instanceof OriginatorInfo) {
            return (OriginatorInfo)obj;
        }
        if (obj != null) {
            return new OriginatorInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Set getCertificates() {
        return this.certs;
    }

    public ASN1Set getCRLs() {
        return this.crls;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        if (this.certs != null) {
            v2.add(new DERTaggedObject(false, 0, this.certs));
        }
        if (this.crls != null) {
            v2.add(new DERTaggedObject(false, 1, this.crls));
        }
        return new DERSequence(v2);
    }
}

