/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.asn1.x509;

import com.timevale.tgtext.bouncycastle.asn1.ASN1EncodableVector;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Object;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Primitive;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Sequence;
import com.timevale.tgtext.bouncycastle.asn1.ASN1TaggedObject;
import com.timevale.tgtext.bouncycastle.asn1.DERSequence;
import com.timevale.tgtext.bouncycastle.asn1.x509.DistributionPoint;

public class CRLDistPoint
extends ASN1Object {
    ASN1Sequence seq = null;

    public static CRLDistPoint getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CRLDistPoint.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CRLDistPoint getInstance(Object obj) {
        if (obj instanceof CRLDistPoint) {
            return (CRLDistPoint)obj;
        }
        if (obj != null) {
            return new CRLDistPoint(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private CRLDistPoint(ASN1Sequence seq) {
        this.seq = seq;
    }

    public CRLDistPoint(DistributionPoint[] points) {
        ASN1EncodableVector v2 = new ASN1EncodableVector();
        for (int i2 = 0; i2 != points.length; ++i2) {
            v2.add(points[i2]);
        }
        this.seq = new DERSequence(v2);
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] dp2 = new DistributionPoint[this.seq.size()];
        for (int i2 = 0; i2 != this.seq.size(); ++i2) {
            dp2[i2] = DistributionPoint.getInstance(this.seq.getObjectAt(i2));
        }
        return dp2;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.seq;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String sep = System.getProperty("line.separator");
        buf.append("CRLDistPoint:");
        buf.append(sep);
        DistributionPoint[] dp2 = this.getDistributionPoints();
        for (int i2 = 0; i2 != dp2.length; ++i2) {
            buf.append("    ");
            buf.append(dp2[i2]);
            buf.append(sep);
        }
        return buf.toString();
    }
}

