/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.signers;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUSigningParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUSigningPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUSigningPublicKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.signers.NTRUSignerPrng;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Polynomial;
import java.nio.ByteBuffer;

public class NTRUSigner {
    private NTRUSigningParameters params;
    private Digest hashAlg;
    private NTRUSigningPrivateKeyParameters signingKeyPair;
    private NTRUSigningPublicKeyParameters verificationKey;

    public NTRUSigner(NTRUSigningParameters params) {
        this.params = params;
    }

    public void init(boolean forSigning, CipherParameters params) {
        if (forSigning) {
            this.signingKeyPair = (NTRUSigningPrivateKeyParameters)params;
        } else {
            this.verificationKey = (NTRUSigningPublicKeyParameters)params;
        }
        this.hashAlg = this.params.hashAlg;
        this.hashAlg.reset();
    }

    public void update(byte b2) {
        if (this.hashAlg == null) {
            throw new IllegalStateException("Call initSign or initVerify first!");
        }
        this.hashAlg.update(b2);
    }

    public void update(byte[] m2, int off, int length) {
        if (this.hashAlg == null) {
            throw new IllegalStateException("Call initSign or initVerify first!");
        }
        this.hashAlg.update(m2, off, length);
    }

    public byte[] generateSignature() {
        if (this.hashAlg == null || this.signingKeyPair == null) {
            throw new IllegalStateException("Call initSign first!");
        }
        byte[] msgHash = new byte[this.hashAlg.getDigestSize()];
        this.hashAlg.doFinal(msgHash, 0);
        return this.signHash(msgHash, this.signingKeyPair);
    }

    private byte[] signHash(byte[] msgHash, NTRUSigningPrivateKeyParameters kp) {
        IntegerPolynomial s2;
        IntegerPolynomial i2;
        int r2 = 0;
        NTRUSigningPublicKeyParameters kPub = kp.getPublicKey();
        do {
            if (++r2 <= this.params.signFailTolerance) continue;
            throw new IllegalStateException("Signing failed: too many retries (max=" + this.params.signFailTolerance + ")");
        } while (!this.verify(i2 = this.createMsgRep(msgHash, r2), s2 = this.sign(i2, kp), kPub.h));
        byte[] rawSig = s2.toBinary(this.params.q);
        ByteBuffer sbuf = ByteBuffer.allocate(rawSig.length + 4);
        sbuf.put(rawSig);
        sbuf.putInt(r2);
        return sbuf.array();
    }

    private IntegerPolynomial sign(IntegerPolynomial i2, NTRUSigningPrivateKeyParameters kp) {
        IntegerPolynomial x2;
        IntegerPolynomial y2;
        Polynomial fPrime;
        Polynomial f2;
        int N = this.params.N;
        int q2 = this.params.q;
        int perturbationBases = this.params.B;
        NTRUSigningPrivateKeyParameters kPriv = kp;
        NTRUSigningPublicKeyParameters kPub = kp.getPublicKey();
        IntegerPolynomial s2 = new IntegerPolynomial(N);
        for (int iLoop = perturbationBases; iLoop > 0; --iLoop) {
            f2 = kPriv.getBasis((int)iLoop).f;
            fPrime = kPriv.getBasis((int)iLoop).fPrime;
            y2 = f2.mult(i2);
            y2.div(q2);
            y2 = fPrime.mult(y2);
            x2 = fPrime.mult(i2);
            x2.div(q2);
            x2 = f2.mult(x2);
            IntegerPolynomial si = y2;
            si.sub(x2);
            s2.add(si);
            IntegerPolynomial hi = (IntegerPolynomial)kPriv.getBasis((int)iLoop).h.clone();
            if (iLoop > 1) {
                hi.sub(kPriv.getBasis((int)(iLoop - 1)).h);
            } else {
                hi.sub(kPub.h);
            }
            i2 = si.mult(hi, q2);
        }
        f2 = kPriv.getBasis((int)0).f;
        fPrime = kPriv.getBasis((int)0).fPrime;
        y2 = f2.mult(i2);
        y2.div(q2);
        y2 = fPrime.mult(y2);
        x2 = fPrime.mult(i2);
        x2.div(q2);
        x2 = f2.mult(x2);
        y2.sub(x2);
        s2.add(y2);
        s2.modPositive(q2);
        return s2;
    }

    public boolean verifySignature(byte[] sig) {
        if (this.hashAlg == null || this.verificationKey == null) {
            throw new IllegalStateException("Call initVerify first!");
        }
        byte[] msgHash = new byte[this.hashAlg.getDigestSize()];
        this.hashAlg.doFinal(msgHash, 0);
        return this.verifyHash(msgHash, sig, this.verificationKey);
    }

    private boolean verifyHash(byte[] msgHash, byte[] sig, NTRUSigningPublicKeyParameters pub) {
        ByteBuffer sbuf = ByteBuffer.wrap(sig);
        byte[] rawSig = new byte[sig.length - 4];
        sbuf.get(rawSig);
        IntegerPolynomial s2 = IntegerPolynomial.fromBinary(rawSig, this.params.N, this.params.q);
        int r2 = sbuf.getInt();
        return this.verify(this.createMsgRep(msgHash, r2), s2, pub.h);
    }

    private boolean verify(IntegerPolynomial i2, IntegerPolynomial s2, IntegerPolynomial h2) {
        long l2;
        int q2 = this.params.q;
        double normBoundSq = this.params.normBoundSq;
        double betaSq = this.params.betaSq;
        IntegerPolynomial t2 = h2.mult(s2, q2);
        t2.sub(i2);
        long centeredNormSq = (long)((double)s2.centeredNormSq(q2) + betaSq * (double)t2.centeredNormSq(q2));
        return (double)l2 <= normBoundSq;
    }

    protected IntegerPolynomial createMsgRep(byte[] msgHash, int r2) {
        int N = this.params.N;
        int q2 = this.params.q;
        int c2 = 31 - Integer.numberOfLeadingZeros(q2);
        int B = (c2 + 7) / 8;
        IntegerPolynomial i2 = new IntegerPolynomial(N);
        ByteBuffer cbuf = ByteBuffer.allocate(msgHash.length + 4);
        cbuf.put(msgHash);
        cbuf.putInt(r2);
        NTRUSignerPrng prng = new NTRUSignerPrng(cbuf.array(), this.params.hashAlg);
        for (int t2 = 0; t2 < N; ++t2) {
            byte[] o2 = prng.nextBytes(B);
            int hi = o2[o2.length - 1];
            hi >>= B * 8 - c2;
            o2[o2.length - 1] = (byte)(hi <<= B * 8 - c2);
            ByteBuffer obuf = ByteBuffer.allocate(4);
            obuf.put(o2);
            obuf.rewind();
            i2.coeffs[t2] = Integer.reverseBytes(obuf.getInt());
        }
        return i2;
    }
}

