/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.io;

import com.timevale.tgtext.bouncycastle.crypto.BufferedBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.StreamCipher;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CipherOutputStream
extends FilterOutputStream {
    private BufferedBlockCipher bufferedBlockCipher;
    private StreamCipher streamCipher;
    private byte[] oneByte = new byte[1];
    private byte[] buf;

    public CipherOutputStream(OutputStream os, BufferedBlockCipher cipher) {
        super(os);
        this.bufferedBlockCipher = cipher;
        this.buf = new byte[cipher.getBlockSize()];
    }

    public CipherOutputStream(OutputStream os, StreamCipher cipher) {
        super(os);
        this.streamCipher = cipher;
    }

    @Override
    public void write(int b2) throws IOException {
        this.oneByte[0] = (byte)b2;
        if (this.bufferedBlockCipher != null) {
            int len = this.bufferedBlockCipher.processBytes(this.oneByte, 0, 1, this.buf, 0);
            if (len != 0) {
                this.out.write(this.buf, 0, len);
            }
            return;
        }
        this.out.write(this.streamCipher.returnByte((byte)b2));
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.write(b2, 0, b2.length);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.bufferedBlockCipher != null) {
            byte[] buf = new byte[this.bufferedBlockCipher.getOutputSize(len)];
            int outLen = this.bufferedBlockCipher.processBytes(b2, off, len, buf, 0);
            if (outLen != 0) {
                this.out.write(buf, 0, outLen);
            }
            return;
        }
        byte[] buf = new byte[len];
        this.streamCipher.processBytes(b2, off, len, buf, 0);
        this.out.write(buf, 0, len);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            byte[] buf;
            int outLen;
            if (this.bufferedBlockCipher != null && (outLen = this.bufferedBlockCipher.doFinal(buf = new byte[this.bufferedBlockCipher.getOutputSize(0)], 0)) != 0) {
                this.out.write(buf, 0, outLen);
            }
        }
        catch (Exception e2) {
            throw new IOException("Error closing stream: " + e2.toString());
        }
        this.flush();
        super.close();
    }
}

