/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.macs;

import com.timevale.tgtext.bouncycastle.crypto.BlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Mac;
import com.timevale.tgtext.bouncycastle.crypto.modes.CBCBlockCipher;
import com.timevale.tgtext.bouncycastle.crypto.paddings.ISO7816d4Padding;

public class CMac
implements Mac {
    private static final byte CONSTANT_128 = -121;
    private static final byte CONSTANT_64 = 27;
    private byte[] ZEROES;
    private byte[] mac;
    private byte[] buf;
    private int bufOff;
    private BlockCipher cipher;
    private int macSize;
    private byte[] L;
    private byte[] Lu;
    private byte[] Lu2;

    public CMac(BlockCipher cipher) {
        this(cipher, cipher.getBlockSize() << 3);
    }

    public CMac(BlockCipher cipher, int macSizeInBits) {
        if (macSizeInBits % 8 != 0) {
            throw new IllegalArgumentException("MAC size must be multiple of 8");
        }
        if (macSizeInBits > cipher.getBlockSize() << 3) {
            throw new IllegalArgumentException("MAC size must be less or equal to " + (cipher.getBlockSize() << 3));
        }
        if (cipher.getBlockSize() != 8 && cipher.getBlockSize() != 16) {
            throw new IllegalArgumentException("Block size must be either 64 or 128 bits");
        }
        this.cipher = new CBCBlockCipher(cipher);
        this.macSize = macSizeInBits / 8;
        this.mac = new byte[cipher.getBlockSize()];
        this.buf = new byte[cipher.getBlockSize()];
        this.ZEROES = new byte[cipher.getBlockSize()];
        this.bufOff = 0;
    }

    @Override
    public String getAlgorithmName() {
        return this.cipher.getAlgorithmName();
    }

    private static byte[] doubleLu(byte[] in) {
        int FirstBit = (in[0] & 0xFF) >> 7;
        byte[] ret = new byte[in.length];
        for (int i2 = 0; i2 < in.length - 1; ++i2) {
            ret[i2] = (byte)((in[i2] << 1) + ((in[i2 + 1] & 0xFF) >> 7));
        }
        ret[in.length - 1] = (byte)(in[in.length - 1] << 1);
        if (FirstBit == 1) {
            int n2 = in.length - 1;
            ret[n2] = (byte)(ret[n2] ^ (in.length == 16 ? -121 : 27));
        }
        return ret;
    }

    @Override
    public void init(CipherParameters params) {
        if (params != null) {
            this.cipher.init(true, params);
            this.L = new byte[this.ZEROES.length];
            this.cipher.processBlock(this.ZEROES, 0, this.L, 0);
            this.Lu = CMac.doubleLu(this.L);
            this.Lu2 = CMac.doubleLu(this.Lu);
        }
        this.reset();
    }

    @Override
    public int getMacSize() {
        return this.macSize;
    }

    @Override
    public void update(byte in) {
        if (this.bufOff == this.buf.length) {
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
        }
        this.buf[this.bufOff++] = in;
    }

    @Override
    public void update(byte[] in, int inOff, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("Can't have a negative input length!");
        }
        int blockSize = this.cipher.getBlockSize();
        int gapLen = blockSize - this.bufOff;
        if (len > gapLen) {
            System.arraycopy(in, inOff, this.buf, this.bufOff, gapLen);
            this.cipher.processBlock(this.buf, 0, this.mac, 0);
            this.bufOff = 0;
            len -= gapLen;
            inOff += gapLen;
            while (len > blockSize) {
                this.cipher.processBlock(in, inOff, this.mac, 0);
                len -= blockSize;
                inOff += blockSize;
            }
        }
        System.arraycopy(in, inOff, this.buf, this.bufOff, len);
        this.bufOff += len;
    }

    @Override
    public int doFinal(byte[] out, int outOff) {
        byte[] lu;
        int blockSize = this.cipher.getBlockSize();
        if (this.bufOff == blockSize) {
            lu = this.Lu;
        } else {
            new ISO7816d4Padding().addPadding(this.buf, this.bufOff);
            lu = this.Lu2;
        }
        for (int i2 = 0; i2 < this.mac.length; ++i2) {
            int n2 = i2;
            this.buf[n2] = (byte)(this.buf[n2] ^ lu[i2]);
        }
        this.cipher.processBlock(this.buf, 0, this.mac, 0);
        System.arraycopy(this.mac, 0, out, outOff, this.macSize);
        this.reset();
        return this.macSize;
    }

    @Override
    public void reset() {
        for (int i2 = 0; i2 < this.buf.length; ++i2) {
            this.buf[i2] = 0;
        }
        this.bufOff = 0;
        this.cipher.reset();
    }
}

