/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;

public class RainbowParameters
implements CipherParameters {
    private final int[] DEFAULT_VI = new int[]{6, 12, 17, 22, 33};
    private int[] vi;

    public RainbowParameters() {
        this.vi = this.DEFAULT_VI;
    }

    public RainbowParameters(int[] vi) {
        this.vi = vi;
        try {
            this.checkParams();
            return;
        }
        catch (Exception exception) {
            Exception e2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    private void checkParams() throws Exception {
        if (this.vi == null) {
            throw new Exception("no layers defined.");
        }
        if (this.vi.length > 1) {
            for (int i2 = 0; i2 < this.vi.length - 1; ++i2) {
                if (this.vi[i2] < this.vi[i2 + 1]) continue;
                throw new Exception("v[i] has to be smaller than v[i+1]");
            }
            return;
        }
        throw new Exception("Rainbow needs at least 1 layer, such that v1 < v2.");
    }

    public int getNumOfLayers() {
        return this.vi.length - 1;
    }

    public int getDocLength() {
        return this.vi[this.vi.length - 1] - this.vi[0];
    }

    public int[] getVi() {
        return this.vi;
    }
}

