/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.cert;

import com.timevale.tgtext.bouncycastle.asn1.ASN1Encodable;
import com.timevale.tgtext.bouncycastle.asn1.ASN1GeneralizedTime;
import com.timevale.tgtext.bouncycastle.asn1.ASN1Integer;
import com.timevale.tgtext.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.timevale.tgtext.bouncycastle.asn1.DERSet;
import com.timevale.tgtext.bouncycastle.asn1.x509.AttCertIssuer;
import com.timevale.tgtext.bouncycastle.asn1.x509.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.timevale.tgtext.bouncycastle.asn1.x509.V2AttributeCertificateInfoGenerator;
import com.timevale.tgtext.bouncycastle.cert.AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.AttributeCertificateIssuer;
import com.timevale.tgtext.bouncycastle.cert.CertIOException;
import com.timevale.tgtext.bouncycastle.cert.X509AttributeCertificateHolder;
import com.timevale.tgtext.bouncycastle.cert.a;
import com.timevale.tgtext.bouncycastle.operator.ContentSigner;
import java.math.BigInteger;
import java.util.Date;

public class X509v2AttributeCertificateBuilder {
    private V2AttributeCertificateInfoGenerator acInfoGen = new V2AttributeCertificateInfoGenerator();
    private ExtensionsGenerator extGenerator = new ExtensionsGenerator();

    public X509v2AttributeCertificateBuilder(AttributeCertificateHolder holder, AttributeCertificateIssuer issuer, BigInteger serialNumber, Date notBefore, Date notAfter) {
        this.acInfoGen.setHolder(holder.holder);
        this.acInfoGen.setIssuer(AttCertIssuer.getInstance(issuer.form));
        this.acInfoGen.setSerialNumber(new ASN1Integer(serialNumber));
        this.acInfoGen.setStartDate(new ASN1GeneralizedTime(notBefore));
        this.acInfoGen.setEndDate(new ASN1GeneralizedTime(notAfter));
    }

    public X509v2AttributeCertificateBuilder addAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable attrValue) {
        this.acInfoGen.addAttribute(new Attribute(attrType, new DERSet(attrValue)));
        return this;
    }

    public X509v2AttributeCertificateBuilder addAttribute(ASN1ObjectIdentifier attrType, ASN1Encodable[] attrValues) {
        this.acInfoGen.addAttribute(new Attribute(attrType, new DERSet(attrValues)));
        return this;
    }

    public void setIssuerUniqueId(boolean[] iui) {
        this.acInfoGen.setIssuerUniqueID(a.a(iui));
    }

    public X509v2AttributeCertificateBuilder addExtension(ASN1ObjectIdentifier oid, boolean isCritical, ASN1Encodable value) throws CertIOException {
        a.a(this.extGenerator, oid, isCritical, value);
        return this;
    }

    public X509AttributeCertificateHolder build(ContentSigner signer) {
        this.acInfoGen.setSignature(signer.getAlgorithmIdentifier());
        if (!this.extGenerator.isEmpty()) {
            this.acInfoGen.setExtensions(this.extGenerator.generate());
        }
        return a.a(signer, this.acInfoGen.generateAttributeCertificateInfo());
    }
}

