/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.gmss;

import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.GMSSDigestProvider;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.Treehash;
import com.timevale.tgtext.bouncycastle.pqc.crypto.gmss.a;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import com.timevale.tgtext.bouncycastle.util.Integers;
import com.timevale.tgtext.bouncycastle.util.encoders.Hex;
import java.util.Enumeration;
import java.util.Vector;

public class GMSSRootCalc {
    private int heightOfTree;
    private int mdLength;
    private Treehash[] treehash;
    private Vector[] retain;
    private byte[] root;
    private byte[][] AuthPath;
    private int K;
    private Vector tailStack;
    private Vector heightOfNodes;
    private Digest messDigestTree;
    private GMSSDigestProvider digestProvider;
    private int[] index;
    private boolean isInitialized;
    private boolean isFinished;
    private int indexForNextSeed;
    private int heightOfNextSeed;

    public GMSSRootCalc(Digest digest, byte[][] statByte, int[] statInt, Treehash[] treeH, Vector[] ret) {
        int i2;
        this.messDigestTree = this.digestProvider.get();
        this.heightOfTree = statInt[0];
        this.mdLength = statInt[1];
        this.K = statInt[2];
        this.indexForNextSeed = statInt[3];
        this.heightOfNextSeed = statInt[4];
        this.isFinished = statInt[5] == 1;
        this.isInitialized = statInt[6] == 1;
        int tailLength = statInt[7];
        this.index = new int[this.heightOfTree];
        for (i2 = 0; i2 < this.heightOfTree; ++i2) {
            this.index[i2] = statInt[i2 + 8];
        }
        this.heightOfNodes = new Vector();
        for (i2 = 0; i2 < tailLength; ++i2) {
            this.heightOfNodes.addElement(Integers.valueOf(statInt[8 + this.heightOfTree + i2]));
        }
        this.root = statByte[0];
        this.AuthPath = new byte[this.heightOfTree][this.mdLength];
        for (i2 = 0; i2 < this.heightOfTree; ++i2) {
            this.AuthPath[i2] = statByte[i2 + 1];
        }
        this.tailStack = new Vector();
        for (i2 = 0; i2 < tailLength; ++i2) {
            this.tailStack.addElement(statByte[1 + this.heightOfTree + i2]);
        }
        this.treehash = a.a(treeH);
        this.retain = a.a(ret);
    }

    public GMSSRootCalc(int heightOfTree, int K, GMSSDigestProvider digestProvider) {
        this.heightOfTree = heightOfTree;
        this.digestProvider = digestProvider;
        this.messDigestTree = digestProvider.get();
        this.mdLength = this.messDigestTree.getDigestSize();
        this.K = K;
        this.index = new int[heightOfTree];
        this.AuthPath = new byte[heightOfTree][this.mdLength];
        this.root = new byte[this.mdLength];
        this.retain = new Vector[this.K - 1];
        for (int i2 = 0; i2 < K - 1; ++i2) {
            this.retain[i2] = new Vector();
        }
    }

    public void initialize(Vector sharedStack) {
        int i2;
        this.treehash = new Treehash[this.heightOfTree - this.K];
        for (i2 = 0; i2 < this.heightOfTree - this.K; ++i2) {
            this.treehash[i2] = new Treehash(sharedStack, i2, this.digestProvider.get());
        }
        this.index = new int[this.heightOfTree];
        this.AuthPath = new byte[this.heightOfTree][this.mdLength];
        this.root = new byte[this.mdLength];
        this.tailStack = new Vector();
        this.heightOfNodes = new Vector();
        this.isInitialized = true;
        this.isFinished = false;
        for (i2 = 0; i2 < this.heightOfTree; ++i2) {
            this.index[i2] = -1;
        }
        this.retain = new Vector[this.K - 1];
        for (i2 = 0; i2 < this.K - 1; ++i2) {
            this.retain[i2] = new Vector();
        }
        this.indexForNextSeed = 3;
        this.heightOfNextSeed = 0;
    }

    public void update(byte[] seed, byte[] leaf) {
        if (this.heightOfNextSeed < this.heightOfTree - this.K && this.indexForNextSeed - 2 == this.index[0]) {
            this.initializeTreehashSeed(seed, this.heightOfNextSeed);
            ++this.heightOfNextSeed;
            this.indexForNextSeed <<= 1;
        }
        this.update(leaf);
    }

    public void update(byte[] leaf) {
        if (this.isFinished) {
            System.out.print("Too much updates for Tree!!");
            return;
        }
        if (!this.isInitialized) {
            System.err.println("GMSSRootCalc not initialized!");
            return;
        }
        this.index[0] = this.index[0] + 1;
        if (this.index[0] == 1) {
            System.arraycopy(leaf, 0, this.AuthPath[0], 0, this.mdLength);
        } else if (this.index[0] == 3 && this.heightOfTree > this.K) {
            this.treehash[0].setFirstNode(leaf);
        }
        if ((this.index[0] - 3) % 2 == 0 && this.index[0] >= 3 && this.heightOfTree == this.K) {
            this.retain[0].insertElementAt(leaf, 0);
        }
        if (this.index[0] == 0) {
            this.tailStack.addElement(leaf);
            this.heightOfNodes.addElement(Integers.valueOf(0));
            return;
        }
        byte[] help = new byte[this.mdLength];
        byte[] toBeHashed = new byte[this.mdLength << 1];
        System.arraycopy(leaf, 0, help, 0, this.mdLength);
        int helpHeight = 0;
        while (this.tailStack.size() > 0 && helpHeight == (Integer)this.heightOfNodes.lastElement()) {
            System.arraycopy(this.tailStack.lastElement(), 0, toBeHashed, 0, this.mdLength);
            this.tailStack.removeElementAt(this.tailStack.size() - 1);
            this.heightOfNodes.removeElementAt(this.heightOfNodes.size() - 1);
            System.arraycopy(help, 0, toBeHashed, this.mdLength, this.mdLength);
            this.messDigestTree.update(toBeHashed, 0, toBeHashed.length);
            help = new byte[this.messDigestTree.getDigestSize()];
            this.messDigestTree.doFinal(help, 0);
            if (++helpHeight >= this.heightOfTree) continue;
            int n2 = helpHeight;
            this.index[n2] = this.index[n2] + 1;
            if (this.index[helpHeight] == 1) {
                System.arraycopy(help, 0, this.AuthPath[helpHeight], 0, this.mdLength);
            }
            if (helpHeight >= this.heightOfTree - this.K) {
                if (helpHeight == 0) {
                    System.out.println("M\ufffd\ufffd\ufffdP");
                }
                if ((this.index[helpHeight] - 3) % 2 != 0 || this.index[helpHeight] < 3) continue;
                this.retain[helpHeight - (this.heightOfTree - this.K)].insertElementAt(help, 0);
                continue;
            }
            if (this.index[helpHeight] != 3) continue;
            this.treehash[helpHeight].setFirstNode(help);
        }
        this.tailStack.addElement(help);
        this.heightOfNodes.addElement(Integers.valueOf(helpHeight));
        if (helpHeight == this.heightOfTree) {
            this.isFinished = true;
            this.isInitialized = false;
            this.root = (byte[])this.tailStack.lastElement();
        }
    }

    public void initializeTreehashSeed(byte[] seed, int index) {
        this.treehash[index].initializeSeed(seed);
    }

    public boolean wasInitialized() {
        return this.isInitialized;
    }

    public boolean wasFinished() {
        return this.isFinished;
    }

    public byte[][] getAuthPath() {
        return a.a(this.AuthPath);
    }

    public Treehash[] getTreehash() {
        return a.a(this.treehash);
    }

    public Vector[] getRetain() {
        return a.a(this.retain);
    }

    public byte[] getRoot() {
        return Arrays.clone(this.root);
    }

    public Vector getStack() {
        Vector copy = new Vector();
        Enumeration en2 = this.tailStack.elements();
        while (en2.hasMoreElements()) {
            copy.addElement(en2.nextElement());
        }
        return copy;
    }

    public byte[][] getStatByte() {
        int i2;
        int tailLength = this.tailStack == null ? 0 : this.tailStack.size();
        byte[][] byArray = new byte[1 + this.heightOfTree + tailLength][64];
        byte[][] statByte = byArray;
        byArray[0] = this.root;
        for (i2 = 0; i2 < this.heightOfTree; ++i2) {
            statByte[i2 + 1] = this.AuthPath[i2];
        }
        for (i2 = 0; i2 < tailLength; ++i2) {
            statByte[1 + this.heightOfTree + i2] = (byte[])this.tailStack.elementAt(i2);
        }
        return statByte;
    }

    public int[] getStatInt() {
        int i2;
        int tailLength = this.tailStack == null ? 0 : this.tailStack.size();
        int[] nArray = new int[8 + this.heightOfTree + tailLength];
        int[] statInt = nArray;
        nArray[0] = this.heightOfTree;
        statInt[1] = this.mdLength;
        statInt[2] = this.K;
        statInt[3] = this.indexForNextSeed;
        statInt[4] = this.heightOfNextSeed;
        statInt[5] = this.isFinished ? 1 : 0;
        statInt[6] = this.isInitialized ? 1 : 0;
        statInt[7] = tailLength;
        for (i2 = 0; i2 < this.heightOfTree; ++i2) {
            statInt[i2 + 8] = this.index[i2];
        }
        for (i2 = 0; i2 < tailLength; ++i2) {
            statInt[8 + this.heightOfTree + i2] = (Integer)this.heightOfNodes.elementAt(i2);
        }
        return statInt;
    }

    public String toString() {
        int i2;
        String out = "";
        int tailLength = this.tailStack == null ? 0 : this.tailStack.size();
        for (i2 = 0; i2 < 8 + this.heightOfTree + tailLength; ++i2) {
            out = out + this.getStatInt()[i2] + " ";
        }
        for (i2 = 0; i2 < 1 + this.heightOfTree + tailLength; ++i2) {
            out = out + new String(Hex.encode(this.getStatByte()[i2])) + " ";
        }
        out = out + "  " + this.digestProvider.get().getDigestSize();
        return out;
    }
}

