/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.tsp;

import com.timevale.tgtext.bouncycastle.asn1.ASN1InputStream;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIFailureInfo;
import com.timevale.tgtext.bouncycastle.asn1.cmp.PKIFreeText;
import com.timevale.tgtext.bouncycastle.asn1.cms.Attribute;
import com.timevale.tgtext.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.timevale.tgtext.bouncycastle.asn1.tsp.TimeStampResp;
import com.timevale.tgtext.bouncycastle.tsp.TSPException;
import com.timevale.tgtext.bouncycastle.tsp.TSPValidationException;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampRequest;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampToken;
import com.timevale.tgtext.bouncycastle.tsp.TimeStampTokenInfo;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TimeStampResponse {
    TimeStampResp resp;
    TimeStampToken timeStampToken;

    public TimeStampResponse(TimeStampResp resp) throws TSPException, IOException {
        this.resp = resp;
        if (resp.getTimeStampToken() != null) {
            this.timeStampToken = new TimeStampToken(resp.getTimeStampToken());
        }
    }

    public TimeStampResponse(byte[] resp) throws TSPException, IOException {
        this(new ByteArrayInputStream(resp));
    }

    public TimeStampResponse(InputStream in) throws TSPException, IOException {
        this(TimeStampResponse.readTimeStampResp(in));
    }

    private static TimeStampResp readTimeStampResp(InputStream in) throws IOException, TSPException {
        try {
            return TimeStampResp.getInstance(new ASN1InputStream(in).readObject());
        }
        catch (IllegalArgumentException e2) {
            throw new TSPException("malformed timestamp response: " + e2, e2);
        }
        catch (ClassCastException e3) {
            throw new TSPException("malformed timestamp response: " + e3, e3);
        }
    }

    public int getStatus() {
        return this.resp.getStatus().getStatus().intValue();
    }

    public String getStatusString() {
        if (this.resp.getStatus().getStatusString() != null) {
            StringBuffer statusStringBuf = new StringBuffer();
            PKIFreeText text = this.resp.getStatus().getStatusString();
            for (int i2 = 0; i2 != text.size(); ++i2) {
                statusStringBuf.append(text.getStringAt(i2).getString());
            }
            return statusStringBuf.toString();
        }
        return null;
    }

    public PKIFailureInfo getFailInfo() {
        if (this.resp.getStatus().getFailInfo() != null) {
            return new PKIFailureInfo(this.resp.getStatus().getFailInfo());
        }
        return null;
    }

    public TimeStampToken getTimeStampToken() {
        return this.timeStampToken;
    }

    public void validate(TimeStampRequest request) throws TSPException {
        TimeStampToken tok = this.getTimeStampToken();
        if (tok != null) {
            TimeStampTokenInfo tstInfo = tok.getTimeStampInfo();
            if (request.getNonce() != null && !request.getNonce().equals(tstInfo.getNonce())) {
                throw new TSPValidationException("response contains wrong nonce value.");
            }
            if (this.getStatus() != 0 && this.getStatus() != 1) {
                throw new TSPValidationException("time stamp token found in failed request.");
            }
            if (!Arrays.constantTimeAreEqual(request.getMessageImprintDigest(), tstInfo.getMessageImprintDigest())) {
                throw new TSPValidationException("response for different message imprint digest.");
            }
            if (!tstInfo.getMessageImprintAlgOID().equals(request.getMessageImprintAlgOID())) {
                throw new TSPValidationException("response for different message imprint algorithm.");
            }
            Attribute scV1 = tok.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificate);
            Attribute scV2 = tok.getSignedAttributes().get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
            if (scV1 == null && scV2 == null) {
                throw new TSPValidationException("no signing certificate attribute present.");
            }
            if (request.getReqPolicy() != null && !request.getReqPolicy().equals(tstInfo.getPolicy())) {
                throw new TSPValidationException("TSA policy wrong for request.");
            }
            return;
        }
        if (this.getStatus() == 0 || this.getStatus() == 1) {
            throw new TSPValidationException("no time stamp token found and one expected.");
        }
    }

    public byte[] getEncoded() throws IOException {
        return this.resp.getEncoded();
    }
}

