/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.tls;

import com.timevale.tgtext.bouncycastle.crypto.CryptoException;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.RSAKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.tls.Certificate;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsClientContext;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsFatalAlert;
import com.timevale.tgtext.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.timevale.tgtext.bouncycastle.crypto.tls.g;
import com.timevale.tgtext.bouncycastle.crypto.tls.j;
import com.timevale.tgtext.bouncycastle.crypto.tls.o;
import com.timevale.tgtext.bouncycastle.crypto.tls.q;
import java.io.IOException;

public class DefaultTlsSignerCredentials
implements TlsSignerCredentials {
    protected TlsClientContext context;
    protected Certificate clientCert;
    protected AsymmetricKeyParameter clientPrivateKey;
    protected q clientSigner;

    public DefaultTlsSignerCredentials(TlsClientContext context, Certificate clientCertificate, AsymmetricKeyParameter clientPrivateKey) {
        if (clientCertificate == null) {
            throw new IllegalArgumentException("'clientCertificate' cannot be null");
        }
        if (clientCertificate.certs.length == 0) {
            throw new IllegalArgumentException("'clientCertificate' cannot be empty");
        }
        if (clientPrivateKey == null) {
            throw new IllegalArgumentException("'clientPrivateKey' cannot be null");
        }
        if (!clientPrivateKey.isPrivate()) {
            throw new IllegalArgumentException("'clientPrivateKey' must be private");
        }
        if (clientPrivateKey instanceof RSAKeyParameters) {
            this.clientSigner = new o();
        } else if (clientPrivateKey instanceof DSAPrivateKeyParameters) {
            this.clientSigner = new g();
        } else if (clientPrivateKey instanceof ECPrivateKeyParameters) {
            this.clientSigner = new j();
        } else {
            throw new IllegalArgumentException("'clientPrivateKey' type not supported: " + clientPrivateKey.getClass().getName());
        }
        this.context = context;
        this.clientCert = clientCertificate;
        this.clientPrivateKey = clientPrivateKey;
    }

    @Override
    public Certificate getCertificate() {
        return this.clientCert;
    }

    @Override
    public byte[] generateCertificateSignature(byte[] md5andsha1) throws IOException {
        try {
            return this.clientSigner.a(this.context.getSecureRandom(), this.clientPrivateKey, md5andsha1);
        }
        catch (CryptoException cryptoException) {
            throw new TlsFatalAlert(80);
        }
    }
}

