/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.pkcs.PKCS12;
import cfca.sadk.asn1.pkcs.PKCS12_SM2;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.asn1.x500.X500Name;
import cfca.sadk.system.FileHelper;
import cfca.sadk.util.Base64;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.util.P10Request;
import cfca.sadk.x509.certificate.X509Cert;
import cfca.sadk.x509.certificate.X509CertGenerator;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;

public final class P12FileKit {
    static volatile Session session = null;

    private P12FileKit() {
    }

    public static final String SM2GenerateKeyPair(int bitLength, String password) throws PKIException {
        byte[] SM2Bytes;
        X509Cert cert;
        KeyPair keypair;
        Session session = P12FileKit.session();
        try {
            keypair = KeyUtil.generateKeyPair(new Mechanism("SM2"), 256, session);
        }
        catch (PKIException e) {
            throw new PKIException("SM2 KeyPair generate failure:", e);
        }
        try {
            cert = P12FileKit.signedMyselfCert(session, keypair, "SM2");
        }
        catch (Exception e) {
            throw new PKIException("SM2 KeyPair signed myself failure", e);
        }
        try {
            SM2Bytes = P12FileKit.SM2CombineP12Data(cert, keypair.getPrivate(), password);
        }
        catch (Exception e) {
            throw new PKIException("SM2 KeyPair failure", e);
        }
        return Base64.toBase64String(SM2Bytes);
    }

    public static final String SM2GenerateP10(String base64EncryptedKeyData, String password) throws PKIException {
        byte[] base64p10;
        PublicKey publicKey;
        PKCS12_SM2 P10;
        if (base64EncryptedKeyData == null) {
            throw new PKIException("SM2 P10 base64EncryptedKeyData should not be null");
        }
        if (password == null) {
            throw new PKIException("SM2 P10 password should not be null");
        }
        Session session = P12FileKit.session();
        try {
            P10 = new PKCS12_SM2();
            P10.load(base64EncryptedKeyData.getBytes());
            P10.decrypt(password);
        }
        catch (Exception e) {
            throw new PKIException("SM2 P10 loading failure ", e);
        }
        PrivateKey privateKey = P10.getPrivateKey();
        try {
            privateKey = P10.getPrivateKey();
        }
        catch (Exception e) {
            throw new PKIException("SM2 P10 Fatched PrivateKey failure", e);
        }
        try {
            publicKey = P10.getPublicCert()[0].getPublicKey();
        }
        catch (Exception e) {
            throw new PKIException("SM2 P10 Fatched PublicKey failure", e);
        }
        X500Name subject = new X500Name("CN=certRequisition,O=CFCA SM2 AGENT,C=CN");
        P10Request p10R = new P10Request(session);
        try {
            base64p10 = p10R.generatePKCS10Request(new Mechanism("sm3WithSM2Encryption"), subject, null, publicKey, privateKey, session);
        }
        catch (PKIException e) {
            throw new PKIException("SM2 P10 Generated PKCS10 failure ", e);
        }
        return new String(base64p10);
    }

    public static final String SM2CombineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        byte[] data;
        X509Cert cert;
        PKCS12_SM2 P10;
        try {
            P10 = new PKCS12_SM2();
            P10.load(base64EncryptedKeyData.getBytes());
            P10.decrypt(password);
        }
        catch (Exception e) {
            throw new PKIException("SM2 Combine loading failure ", e);
        }
        PrivateKey privateKey = P10.getPrivateKey();
        try {
            privateKey = P10.getPrivateKey();
        }
        catch (Exception e) {
            throw new PKIException("SM2 Combine Fatched PrivateKey failure", e);
        }
        try {
            cert = new X509Cert(base64CertData.getBytes());
        }
        catch (PKIException e) {
            throw new PKIException("SM2 Combine Fatched X509Cert failure", e);
        }
        try {
            data = P12FileKit.SM2CombineP12Data(cert, privateKey, password);
        }
        catch (Exception e) {
            throw new PKIException("SM2 Combine failure", e);
        }
        return Base64.toBase64String(data);
    }

    public static String SM2CombineP12File(X509Cert x509Cert, PrivateKey priKey, String passWord, String fileName) throws PKIException {
        if (fileName == null) {
            throw new PKIException("SM2File fileName should not be null");
        }
        byte[] encoding = P12FileKit.SM2CombineP12Data(x509Cert, priKey, passWord);
        try {
            FileHelper.write(fileName, encoding);
        }
        catch (IOException e) {
            throw new PKIException("SM2File write failure with IOException", e);
        }
        return fileName;
    }

    public static byte[] SM2CombineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        return PKCS12_SM2.CombineSM2Data(x509Cert, priKey, password);
    }

    public static final String RSAGenerateKeyPair(int bitLength, String password) throws PKIException {
        byte[] pfxBytes;
        X509Cert cert;
        KeyPair keypair;
        Session session = P12FileKit.session();
        if (bitLength != 1024 && bitLength != 2048) {
            throw new PKIException("PFX KeyPair Invalid bitLength=" + bitLength);
        }
        try {
            keypair = KeyUtil.generateKeyPair(new Mechanism("RSA"), bitLength, session);
        }
        catch (PKIException e) {
            throw new PKIException("PFX KeyPair generate failure:", e);
        }
        try {
            cert = P12FileKit.signedMyselfCert(session, keypair, "RSA");
        }
        catch (Exception e) {
            throw new PKIException("PFX KeyPair signed myself failure", e);
        }
        try {
            pfxBytes = P12FileKit.RSACombineP12Data(cert, keypair.getPrivate(), password);
        }
        catch (Exception e) {
            throw new PKIException("PFX KeyPair failure", e);
        }
        return Base64.toBase64String(pfxBytes);
    }

    public static final String RSAGenerateP10(String base64EncryptedKeyData, String password) throws PKIException {
        byte[] base64p10;
        PublicKey publicKey;
        PKCS12 P10;
        if (base64EncryptedKeyData == null) {
            throw new PKIException("PFX P10 base64EncryptedKeyData should not be null");
        }
        if (password == null) {
            throw new PKIException("PFX P10 password should not be null");
        }
        Session session = P12FileKit.session();
        try {
            P10 = new PKCS12();
            P10.load(base64EncryptedKeyData.getBytes());
            P10.decrypt(password.toCharArray());
        }
        catch (Exception e) {
            throw new PKIException("PFX P10 loading failure ", e);
        }
        PrivateKey privateKey = P10.getPrivateKey();
        try {
            privateKey = P10.getPrivateKey();
        }
        catch (Exception e) {
            throw new PKIException("PFX P10 Fatched PrivateKey failure", e);
        }
        try {
            publicKey = P10.getCerts()[0].getPublicKey();
        }
        catch (Exception e) {
            throw new PKIException("PFX P10 Fatched PublicKey failure", e);
        }
        X500Name subject = new X500Name("CN=certRequisition,O=CFCA RSA AGENT,C=CN");
        P10Request p10R = new P10Request(session);
        try {
            base64p10 = p10R.generatePKCS10Request(new Mechanism("sha256WithRSAEncryption"), subject, null, publicKey, privateKey, session);
        }
        catch (PKIException e) {
            throw new PKIException("PFX P10 Generated PKCS10 failure ", e);
        }
        return new String(base64p10);
    }

    public static final String RSACombineP12(String base64EncryptedKeyData, String base64CertData, String password) throws PKIException {
        byte[] data;
        X509Cert cert;
        PKCS12 P10;
        try {
            P10 = new PKCS12();
            P10.load(base64EncryptedKeyData.getBytes());
            P10.decrypt(password.toCharArray());
        }
        catch (Exception e) {
            throw new PKIException("PFX Combine loading failure ", e);
        }
        PrivateKey privateKey = P10.getPrivateKey();
        try {
            privateKey = P10.getPrivateKey();
        }
        catch (Exception e) {
            throw new PKIException("PFX Combine Fatched PrivateKey failure", e);
        }
        try {
            cert = new X509Cert(base64CertData.getBytes());
        }
        catch (PKIException e) {
            throw new PKIException("PFX Combine Decoded X509Cert failure", e);
        }
        try {
            data = P12FileKit.RSACombineP12Data(cert, privateKey, password);
        }
        catch (Exception e) {
            throw new PKIException("PFX Combine failure", e);
        }
        return Base64.toBase64String(data);
    }

    public static String RSACombineP12File(X509Cert x509Cert, PrivateKey priKey, String password, String fileName) throws PKIException {
        if (fileName == null) {
            throw new PKIException("PFXFile fileName should not be null");
        }
        byte[] encoding = P12FileKit.RSACombineP12Data(x509Cert, priKey, password);
        try {
            FileHelper.write(fileName, encoding);
        }
        catch (Exception e) {
            throw new PKIException("PFXFile write failure", e);
        }
        return fileName;
    }

    public static byte[] RSACombineP12Data(X509Cert x509Cert, PrivateKey priKey, String password) throws PKIException {
        return PKCS12.generatePfxData(x509Cert, priKey, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Session session() throws PKIException {
        if (session == null) {
            Class clazz = Session.class;
            synchronized (clazz) {
                if (session == null) {
                    try {
                        String deviceName = "JSOFT_LIB";
                        JCrypto.getInstance().initialize("JSOFT_LIB", null);
                        session = JCrypto.getInstance().openSession("JSOFT_LIB");
                    }
                    catch (PKIException e) {
                        throw new PKIException("Open session failure: " + e.getMessage());
                    }
                }
            }
        }
        return session;
    }

    private static final X509Cert signedMyselfCert(Session session, KeyPair keypair, String keyType) throws Exception {
        X509CertGenerator gen = new X509CertGenerator();
        String algorithm = "RSA".equals(keyType) ? "sha256WithRSAEncryption" : "sm3WithSM2Encryption";
        String TESTDN = "CN=" + keyType + " P10 AGENT,OU=CFCA SADK P10 RSA ,O=CFCA TEST,C=CN";
        gen.setIssuer(TESTDN);
        gen.setSubject(TESTDN);
        gen.setSerialNumber(BigInteger.valueOf(1L));
        gen.setNotAfter(new Date());
        gen.setNotBefore(new Date());
        gen.setPublicKey(keypair.getPublic());
        gen.setSignatureAlg(algorithm);
        byte[] encoding = gen.generateX509Cert(keypair.getPrivate(), session);
        return new X509Cert(encoding);
    }
}

