/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls;

import cfca.sadk.org.bouncycastle.crypto.tls.DeferredHash;
import cfca.sadk.org.bouncycastle.crypto.tls.ProtocolVersion;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsCipher;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsCompression;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsContext;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsHandshakeHash;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsNullCipher;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsNullCompression;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsProtocol;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class RecordStream {
    private static int DEFAULT_PLAINTEXT_LIMIT = 16384;
    private TlsProtocol handler;
    private InputStream input;
    private OutputStream output;
    private TlsCompression pendingCompression = null;
    private TlsCompression readCompression = null;
    private TlsCompression writeCompression = null;
    private TlsCipher pendingCipher = null;
    private TlsCipher readCipher = null;
    private TlsCipher writeCipher = null;
    private long readSeqNo = 0L;
    private long writeSeqNo = 0L;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private TlsContext context = null;
    private TlsHandshakeHash handshakeHash = null;
    private ProtocolVersion readVersion = null;
    private ProtocolVersion writeVersion = null;
    private boolean restrictReadVersion = true;
    private int plaintextLimit;
    private int compressedLimit;
    private int ciphertextLimit;

    RecordStream(TlsProtocol handler, InputStream input, OutputStream output) {
        this.handler = handler;
        this.input = input;
        this.output = output;
        this.writeCompression = this.readCompression = new TlsNullCompression();
        this.writeCipher = this.readCipher = new TlsNullCipher(this.context);
        this.setPlaintextLimit(DEFAULT_PLAINTEXT_LIMIT);
    }

    void init(TlsContext context) {
        this.context = context;
        this.handshakeHash = new DeferredHash();
        this.handshakeHash.init(context);
    }

    int getPlaintextLimit() {
        return this.plaintextLimit;
    }

    void setPlaintextLimit(int plaintextLimit) {
        this.plaintextLimit = plaintextLimit;
        this.compressedLimit = this.plaintextLimit + 1024;
        this.ciphertextLimit = this.compressedLimit + 1024;
    }

    ProtocolVersion getReadVersion() {
        return this.readVersion;
    }

    void setReadVersion(ProtocolVersion readVersion) {
        this.readVersion = readVersion;
    }

    void setWriteVersion(ProtocolVersion writeVersion) {
        this.writeVersion = writeVersion;
    }

    void setRestrictReadVersion(boolean enabled) {
        this.restrictReadVersion = enabled;
    }

    void setPendingConnectionState(TlsCompression tlsCompression, TlsCipher tlsCipher) {
        this.pendingCompression = tlsCompression;
        this.pendingCipher = tlsCipher;
    }

    void sentWriteCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.writeCompression = this.pendingCompression;
        this.writeCipher = this.pendingCipher;
        this.writeSeqNo = 0L;
    }

    void receivedReadCipherSpec() throws IOException {
        if (this.pendingCompression == null || this.pendingCipher == null) {
            throw new TlsFatalAlert(40);
        }
        this.readCompression = this.pendingCompression;
        this.readCipher = this.pendingCipher;
        this.readSeqNo = 0L;
    }

    void finaliseHandshake() throws IOException {
        if (this.readCompression != this.pendingCompression || this.writeCompression != this.pendingCompression || this.readCipher != this.pendingCipher || this.writeCipher != this.pendingCipher) {
            throw new TlsFatalAlert(40);
        }
        this.pendingCompression = null;
        this.pendingCipher = null;
    }

    public boolean readRecord() throws IOException {
        byte[] recordHeader = TlsUtils.readAllOrNothing(5, this.input);
        if (recordHeader == null) {
            return false;
        }
        short type = TlsUtils.readUint8(recordHeader, 0);
        RecordStream.checkType(type, (short)10);
        if (!this.restrictReadVersion) {
            int version = TlsUtils.readVersionRaw(recordHeader, 1);
            if ((version & 0xFFFFFF00) != 768) {
                throw new TlsFatalAlert(47);
            }
        } else {
            ProtocolVersion version = TlsUtils.readVersion(recordHeader, 1);
            if (this.readVersion == null) {
                this.readVersion = version;
            } else if (!version.equals(this.readVersion)) {
                throw new TlsFatalAlert(47);
            }
        }
        int length = TlsUtils.readUint16(recordHeader, 3);
        byte[] plaintext = this.decodeAndVerify(type, this.input, length);
        this.handler.processRecord(type, plaintext, 0, plaintext.length);
        return true;
    }

    protected byte[] decodeAndVerify(short type, InputStream input, int len) throws IOException {
        RecordStream.checkLength(len, this.ciphertextLimit, (short)22);
        byte[] buf = TlsUtils.readFully(len, input);
        byte[] decoded = this.readCipher.decodeCiphertext(this.readSeqNo++, type, buf, 0, buf.length);
        RecordStream.checkLength(decoded.length, this.compressedLimit, (short)22);
        OutputStream cOut = this.readCompression.decompress(this.buffer);
        if (cOut != this.buffer) {
            cOut.write(decoded, 0, decoded.length);
            cOut.flush();
            decoded = this.getBufferContents();
        }
        RecordStream.checkLength(decoded.length, this.plaintextLimit, (short)30);
        if (decoded.length < 1 && type != 23) {
            throw new TlsFatalAlert(47);
        }
        return decoded;
    }

    protected void writeRecord(short type, byte[] plaintext, int plaintextOffset, int plaintextLength) throws IOException {
        byte[] ciphertext;
        OutputStream cOut;
        if (this.writeVersion == null) {
            return;
        }
        RecordStream.checkType(type, (short)80);
        RecordStream.checkLength(plaintextLength, this.plaintextLimit, (short)80);
        if (plaintextLength < 1 && type != 23) {
            throw new TlsFatalAlert(80);
        }
        if (type == 22) {
            this.updateHandshakeData(plaintext, plaintextOffset, plaintextLength);
        }
        if ((cOut = this.writeCompression.compress(this.buffer)) == this.buffer) {
            ciphertext = this.writeCipher.encodePlaintext(this.writeSeqNo++, type, plaintext, plaintextOffset, plaintextLength);
        } else {
            cOut.write(plaintext, plaintextOffset, plaintextLength);
            cOut.flush();
            byte[] compressed = this.getBufferContents();
            RecordStream.checkLength(compressed.length, plaintextLength + 1024, (short)80);
            ciphertext = this.writeCipher.encodePlaintext(this.writeSeqNo++, type, compressed, 0, compressed.length);
        }
        RecordStream.checkLength(ciphertext.length, this.ciphertextLimit, (short)80);
        byte[] record = new byte[ciphertext.length + 5];
        TlsUtils.writeUint8(type, record, 0);
        TlsUtils.writeVersion(this.writeVersion, record, 1);
        TlsUtils.writeUint16(ciphertext.length, record, 3);
        System.arraycopy(ciphertext, 0, record, 5, ciphertext.length);
        this.output.write(record);
        this.output.flush();
    }

    void notifyHelloComplete() {
        this.handshakeHash = this.handshakeHash.notifyPRFDetermined();
    }

    TlsHandshakeHash getHandshakeHash() {
        return this.handshakeHash;
    }

    TlsHandshakeHash prepareToFinish() {
        TlsHandshakeHash result = this.handshakeHash;
        this.handshakeHash = this.handshakeHash.stopTracking();
        return result;
    }

    void updateHandshakeData(byte[] message, int offset, int len) {
        this.handshakeHash.update(message, offset, len);
    }

    protected void safeClose() {
        try {
            this.input.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.output.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void flush() throws IOException {
        this.output.flush();
    }

    private byte[] getBufferContents() {
        byte[] contents = this.buffer.toByteArray();
        this.buffer.reset();
        return contents;
    }

    private static void checkType(short type, short alertDescription) throws IOException {
        switch (type) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            default: {
                throw new TlsFatalAlert(alertDescription);
            }
        }
    }

    private static void checkLength(int length, int limit, short alertDescription) throws IOException {
        if (length > limit) {
            throw new TlsFatalAlert(alertDescription);
        }
    }
}

