/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.x509.certificate;

import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.asn1.parser.ASN1Parser;
import cfca.sadk.org.bouncycastle.asn1.x509.CertificateList;
import cfca.sadk.org.bouncycastle.crypto.Digest;
import cfca.sadk.org.bouncycastle.util.io.Streams;
import cfca.sadk.system.FileHelper;
import cfca.sadk.x509.certificate.CRLFindResult;
import cfca.sadk.x509.certificate.CRLLengths;
import cfca.sadk.x509.certificate.CRLRecord;
import cfca.sadk.x509.certificate.CRLStructure;
import cfca.sadk.x509.certificate.X509CRLBase;
import cfca.sadk.x509.certificate.X509CRLFile;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.HashSet;

public class X509CRL
extends X509CRLBase {
    byte[] derCRL;
    boolean cachesFinished = false;
    final HashSet caches = new HashSet();

    public X509CRL(byte[] derCRL) throws PKIException {
        if (derCRL == null) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": missing derCRL");
        }
        this.loadEncoding(derCRL);
    }

    public X509CRL(CertificateList certList) {
        if (certList == null) {
            throw new IllegalArgumentException(" missing certList");
        }
        try {
            this.loadEncoding(certList.getEncoded());
        }
        catch (PKIException e) {
            throw new SecurityException(e.getMessage());
        }
        catch (Exception e) {
            throw new SecurityException(PKIException.INIT_CRL_DES + ": " + e.getMessage());
        }
        catch (Throwable e) {
            throw new SecurityException(PKIException.INIT_CRL_DES + ": " + e.getMessage());
        }
    }

    public X509CRL(String crlFilePath) throws PKIException {
        byte[] derCRL;
        if (crlFilePath == null) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": missing crlFilePath");
        }
        try {
            File file = new File(crlFilePath);
            this.checkJVMXmxMemory(file.length(), 4);
            derCRL = FileHelper.read(crlFilePath);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES, e);
        }
        catch (Throwable e) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": " + e.getMessage());
        }
        this.loadEncoding(derCRL);
    }

    public X509CRL(InputStream crlInputStream) throws PKIException {
        if (crlInputStream == null) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": missing crlInputStream");
        }
        int minLength = 80;
        byte[] data = new byte[80];
        int derLength = 0;
        try {
            int totalRead;
            int numRead;
            int offset = 0;
            for (totalRead = 0; totalRead < 80 && (numRead = crlInputStream.read(data, offset + totalRead, 80 - totalRead)) >= 0; totalRead += numRead) {
            }
            if (totalRead != 80) {
                throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": too shortage of crlFile");
            }
            derLength = CRLLengths.buildLengthsFrom((byte[])data, (int)0, (int)0).asn1Length;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": read header of crlFile failure", e);
        }
        catch (Throwable e) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": read header of crlFile failure-->" + e.getMessage());
        }
        if (derLength < 80) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": invalid length of crlFile");
        }
        this.checkJVMXmxMemory(derLength, 4);
        byte[] content = null;
        try {
            content = new byte[derLength];
            System.arraycopy(data, 0, content, 0, data.length);
            int remainLength = derLength - 80;
            if (Streams.readFully(crlInputStream, content, 80, remainLength) != remainLength) {
                throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": missing content of crlFile");
            }
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": read content of crlFile failure", e);
        }
        catch (Throwable e) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": read header of crlFile failure-->" + e.getMessage());
        }
        finally {
            data = null;
        }
        this.loadEncoding(content);
    }

    private final byte[] loadEncoding(byte[] derCRL) throws PKIException {
        if (derCRL == null) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": missing derCRL");
        }
        if (derCRL.length < 80 || !ASN1Parser.isDERSequence(derCRL)) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": invalid derCRL");
        }
        try {
            CRLLengths crlLentgs;
            try {
                crlLentgs = CRLLengths.buildLengthsFrom(derCRL, 0, 48);
            }
            catch (IOException e) {
                throw new PKIException("CrlFile verify failure when invalid asn1Length --> ", e);
            }
            if (crlLentgs.asn1Length != derCRL.length) {
                throw new PKIException("CrlFile verify failure when invalid asn1Length --> " + crlLentgs.asn1Length);
            }
            long fileLength = derCRL.length;
            int position = crlLentgs.headLength;
            this.crlStructure = new CRLStructure(null, position, fileLength, derCRL);
            this.derCRL = derCRL;
            return derCRL;
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES, e);
        }
        catch (Throwable e) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": " + e.getMessage());
        }
    }

    public final boolean loadAllRecordsToMemory() throws PKIException {
        boolean success = false;
        if (!this.cachesFinished) {
            try {
                this.checkJVMXmxMemory(this.derCRL.length, 4);
                if (this.crlStructure.isNoneCertTag()) {
                    boolean bl = false;
                    return bl;
                }
                int endIndex = this.crlStructure.context.certsTag.begin + this.crlStructure.context.certsTag.length;
                int offset = this.crlStructure.context.certsTag.begin;
                CRLFindResult.loadBlock(this.derCRL, offset, endIndex, this.caches);
                success = true;
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": load records of crlFile failure", e);
            }
            catch (Throwable e) {
                throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ": load records of crlFile failure-->" + e.getMessage());
            }
            finally {
                if (success) {
                    this.cachesFinished = true;
                } else {
                    this.caches.clear();
                }
            }
        } else {
            success = true;
        }
        return success;
    }

    public CertificateList getCertificateList() {
        try {
            this.checkJVMXmxMemory(this.derCRL.length, 16);
        }
        catch (PKIException e) {
            throw new SecurityException(e.getMessage());
        }
        try {
            return CertificateList.getInstance(this.derCRL);
        }
        catch (Exception e) {
            throw new SecurityException("Failure on CertificateList" + e.getMessage());
        }
        catch (Throwable e) {
            throw new SecurityException("Failure on CertificateList" + e.getMessage());
        }
    }

    public byte[] getEncoded() throws PKIException {
        return this.derCRL;
    }

    public byte[] getTBSCertList() throws PKIException {
        return this.crlStructure.getTBSEncoded(this.derCRL);
    }

    public boolean isRevoke(BigInteger serialNumber) {
        if (serialNumber == null || this.crlStructure.isNoneCertTag()) {
            return false;
        }
        if (this.cachesFinished) {
            return this.caches.contains(new CRLRecord(serialNumber.toByteArray()));
        }
        byte[] certsn = serialNumber.toByteArray();
        boolean isRevoke = false;
        try {
            int endIndex = this.crlStructure.context.certsTag.begin + this.crlStructure.context.certsTag.length;
            int offset = this.crlStructure.context.certsTag.begin;
            CRLFindResult findResults = CRLFindResult.findBlock(this.derCRL, offset, endIndex, certsn);
            isRevoke = findResults.isRevoke;
        }
        catch (Exception e) {
            throw new SecurityException("CrlFile verify failure: " + e.getMessage());
        }
        return isRevoke;
    }

    public static boolean verify(String crlPath, String certPath) throws FileNotFoundException, IOException, PKIException {
        X509Cert cert = new X509Cert(certPath);
        X509CRLFile crlFile = new X509CRLFile(crlPath, false);
        return crlFile.verify(cert.getPublicKey());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (int index = 0; index < this.derCRL.length; ++index) {
            result = 31 * result + this.derCRL[index];
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        X509CRL other = (X509CRL)obj;
        return Arrays.equals(this.derCRL, other.derCRL);
    }

    public String toString() {
        StringBuffer builder = new StringBuffer();
        builder.append("X509CRL [");
        if (this.crlStructure != null) {
            this.crlStructure.dump(builder);
        }
        builder.append("]");
        return builder.toString();
    }

    public final byte[] hash(Digest hashEngine) throws PKIException {
        byte[] hashValue = new byte[hashEngine.getDigestSize()];
        hashEngine.update(this.derCRL, this.crlStructure.contextTag.begin, this.crlStructure.contextTag.length);
        hashEngine.doFinal(hashValue, 0);
        return hashValue;
    }

    final void checkJVMXmxMemory(long fileLength, int times) throws PKIException {
        long maxLength = Runtime.getRuntime().maxMemory() / (long)times;
        if (fileLength > maxLength) {
            throw new PKIException(PKIException.INIT_CRL, PKIException.INIT_CRL_DES + ":JVM effective virtual memory MUST BE " + times + " times with the size of crlFile");
        }
    }
}

