/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.util;

import cfca.sadk.algorithm.common.CBCParam;
import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.algorithm.sm2.SM2PrivateKey;
import cfca.sadk.algorithm.sm2.SM2PublicKey;
import cfca.sadk.algorithm.sm2.SM3Digest;
import cfca.sadk.algorithm.sm2.SM4Engine;
import cfca.sadk.algorithm.util.RSAAndItsCloseSymAlgUtil;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.org.bouncycastle.crypto.BlockCipher;
import cfca.sadk.org.bouncycastle.crypto.engines.DESedeEngine;
import cfca.sadk.org.bouncycastle.crypto.modes.CBCBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.paddings.PKCS7Padding;
import cfca.sadk.org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.params.ParametersWithIV;
import cfca.sadk.system.FileHelper;
import cfca.sadk.system.SM2OutputFormat;
import cfca.sadk.system.global.FileAndBufferConfig;
import cfca.sadk.util.Base64;
import cfca.sadk.util.KeyUtil;
import cfca.sadk.x509.certificate.X509Cert;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;

public class EncryptUtil {
    private static boolean isHex(String str) {
        if (str == null) {
            return false;
        }
        String lowStr = str.toLowerCase();
        int len = lowStr.length();
        for (int i = 0; i < len; ++i) {
            if (lowStr.charAt(i) >= '0' && lowStr.charAt(i) <= '9' || lowStr.charAt(i) >= 'a' && lowStr.charAt(i) <= 'f') continue;
            return false;
        }
        return true;
    }

    private static byte[] HexToByte(String hexStr) throws UnsupportedEncodingException {
        byte[] lowerData = hexStr.toLowerCase().getBytes("UTF-8");
        int len = lowerData.length;
        byte[] workData = null;
        byte[] resultData = null;
        if (len % 2 == 1) {
            workData = new byte[++len];
            workData[0] = 0;
            System.arraycopy(lowerData, 0, workData, 1, len - 1);
        } else {
            workData = new byte[len];
            workData = (byte[])lowerData.clone();
        }
        int resultDataLen = len / 2;
        resultData = new byte[resultDataLen];
        for (int i = 0; i < len; i += 2) {
            byte datum;
            workData[i] = workData[i] >= 48 && workData[i] <= 57 ? (byte)(workData[i] - 48) : (byte)(workData[i] - 87);
            workData[i + 1] = workData[i + 1] >= 48 && workData[i + 1] <= 57 ? (byte)(workData[i + 1] - 48) : (byte)(workData[i + 1] - 87);
            resultData[i / 2] = datum = (byte)(workData[i] << 4 | workData[i + 1]);
        }
        return resultData;
    }

    private static byte[] doWithPWD(byte[] data, String pwd, boolean encryptFlag) throws Exception {
        byte[] ivKey = EncryptUtil.HexToByte(pwd);
        Mechanism algName = new Mechanism("DESede/CBC/PKCS7Padding");
        byte[] iv = new byte[8];
        byte[] key = new byte[24];
        System.arraycopy(ivKey, 0, iv, 0, 8);
        System.arraycopy(ivKey, 8, key, 0, 24);
        algName.setParam(new CBCParam(iv));
        if (encryptFlag) {
            return RSAAndItsCloseSymAlgUtil.crypto(false, true, key, data, algName);
        }
        return RSAAndItsCloseSymAlgUtil.crypto(false, false, key, data, algName);
    }

    private static byte[] doDES3WithCBC(byte[] data, byte[] iv, byte[] key, boolean ifEncrypt) throws Exception {
        if (iv.length != 8 || key.length != 24) {
            throw new PKIException("iv.length must be 8 bytes and key.length must be 24 bytes!");
        }
        Mechanism algName = new Mechanism("DESede/CBC/PKCS7Padding");
        algName.setParam(new CBCParam(iv));
        if (ifEncrypt) {
            return RSAAndItsCloseSymAlgUtil.crypto(false, true, key, data, algName);
        }
        return RSAAndItsCloseSymAlgUtil.crypto(false, false, key, data, algName);
    }

    public static String encryptMessageByDES3(String sourceData, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] sourceData_utf8 = sourceData.getBytes("UTF-8");
                byte[] encryptData = EncryptUtil.doWithPWD(sourceData_utf8, password, true);
                return new String(Base64.encode(encryptData), "UTF-8");
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("Encrypt Failure", e);
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, String certFilePath, Session session) throws PKIException {
        X509Cert x509Cert = new X509Cert(certFilePath);
        PublicKey pubKey = x509Cert.getPublicKey();
        SM2PublicKey sm2PubKey = null;
        if (!(pubKey instanceof SM2PublicKey)) {
            throw new PKIException("key is not SM2Publickey, SM2Publickey expected!");
        }
        sm2PubKey = (SM2PublicKey)pubKey;
        Mechanism mechanism = new Mechanism("SM2");
        return EncryptUtil.encryptForECITIC(mechanism, sm2PubKey, sourceData, session);
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, X509Cert x509Cert, Session session) throws PKIException {
        PublicKey pubKey = x509Cert.getPublicKey();
        SM2PublicKey sm2PubKey = null;
        if (!(pubKey instanceof SM2PublicKey)) {
            throw new PKIException("key is not SM2Publickey, SM2Publickey expected!");
        }
        sm2PubKey = (SM2PublicKey)pubKey;
        Mechanism mechanism = new Mechanism("SM2");
        return EncryptUtil.encryptForECITIC(mechanism, sm2PubKey, sourceData, session);
    }

    public static byte[] encryptMessageBySM2(byte[] sourceData, Key key, Session session) throws PKIException {
        SM2PublicKey pubKey = null;
        if (!(key instanceof SM2PublicKey)) {
            throw new PKIException("key is not SM2Publickey, SM2Publickey expected!");
        }
        pubKey = (SM2PublicKey)key;
        Mechanism mechanism = new Mechanism("SM2");
        return EncryptUtil.encryptForECITIC(mechanism, pubKey, sourceData, session);
    }

    public static byte[] decryptMessageBySM2(byte[] encryptedData, String sm2FilePath, String sm2FilePwd, Session session) throws PKIException {
        SM2PrivateKey sm2PrivKey = KeyUtil.getPrivateKeyFromSM2(sm2FilePath, sm2FilePwd);
        Mechanism mechanism = new Mechanism("SM2");
        return EncryptUtil.decrypt(mechanism, sm2PrivKey, encryptedData, session);
    }

    public static byte[] decryptMessageBySM2(byte[] encryptedData, Key key, Session session) throws PKIException {
        SM2PrivateKey sm2PrivKey = null;
        if (!(key instanceof SM2PrivateKey)) {
            throw new PKIException("key is not SM2PrivateKey, SM2PrivateKey expected!");
        }
        sm2PrivKey = (SM2PrivateKey)key;
        Mechanism mechanism = new Mechanism("SM2");
        return EncryptUtil.decrypt(mechanism, sm2PrivKey, encryptedData, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, String certFilePath, Session session) throws PKIException {
        X509Cert x509Cert = new X509Cert(certFilePath);
        PublicKey pubKey = x509Cert.getPublicKey();
        return EncryptUtil.encryptMessageByRSA(sourceData, pubKey, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, X509Cert x509Cert, Session session) throws PKIException {
        PublicKey pubKey = x509Cert.getPublicKey();
        return EncryptUtil.encryptMessageByRSA(sourceData, pubKey, session);
    }

    public static byte[] encryptMessageByRSA(byte[] sourceData, Key key, Session session) throws PKIException {
        PublicKey pubKey = null;
        if (!(key instanceof PublicKey)) {
            throw new PKIException("key is not Publickey, PublicKey expected!");
        }
        pubKey = (PublicKey)key;
        Mechanism mechanism = new Mechanism("RSA/ECB/PKCS1PADDING");
        return EncryptUtil.encryptForECITIC(mechanism, pubKey, sourceData, session);
    }

    public static byte[] decryptMessageByRSA(byte[] encryptData, String pfxFilePath, String pfxFilePwd, Session session) throws PKIException {
        PrivateKey prvKey = KeyUtil.getPrivateKeyFromPFX(pfxFilePath, pfxFilePwd);
        return EncryptUtil.decryptMessageByRSA(encryptData, prvKey, session);
    }

    public static byte[] decryptMessageByRSA(byte[] encryptData, Key key, Session session) throws PKIException {
        PrivateKey prvKey = null;
        if (!(key instanceof PrivateKey)) {
            throw new PKIException("key is not PrivateKey, PrivateKey expected!");
        }
        prvKey = (PrivateKey)key;
        Mechanism mechanism = new Mechanism("RSA/ECB/PKCS1PADDING");
        return EncryptUtil.decrypt(mechanism, prvKey, encryptData, session);
    }

    public static void encryptFileBySM2(String sourceFilePath, String encryptFilePath, X509Cert x509Cert, Session session) throws PKIException {
        try {
            byte[] data = FileHelper.read(sourceFilePath);
            data = EncryptUtil.encryptMessageBySM2(data, x509Cert, session);
            FileHelper.write(encryptFilePath, data);
        }
        catch (IOException e) {
            throw new PKIException("EncryptFileBySM2 failure", e);
        }
    }

    public static void decryptFileBySM2(String encryptFilePath, String decryptFilePath, SM2PrivateKey sm2PrvKey, Session session) throws PKIException {
        try {
            byte[] data = FileHelper.read(encryptFilePath);
            data = EncryptUtil.decryptMessageBySM2(data, sm2PrvKey, session);
            FileHelper.write(decryptFilePath, data);
        }
        catch (IOException e) {
            throw new PKIException("DecryptFileBySM2 failure", e);
        }
    }

    public static String decryptMessageByDES3(String encryptData, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] encryptData_utf8 = Base64.decode(encryptData.getBytes("UTF-8"));
                byte[] sourceData = EncryptUtil.doWithPWD(encryptData_utf8, password, false);
                return new String(sourceData, "UTF-8");
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("Decrypt Failure", e);
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static void encryptFileByDES3(String sourceFilePath, String encryptFilePath, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            FileOutputStream fos = null;
            try {
                byte[] ivKey = EncryptUtil.HexToByte(password);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam(iv);
                fos = new FileOutputStream(encryptFilePath);
                EncryptUtil.bigFileBlockEncrypt(true, key, (BlockCipher)new DESedeEngine(), param, new File(sourceFilePath), fos);
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("Encrypt Failure", e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static void decryptFileByDES3(String encryptFilePath, String plainTextFilePath, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            FileOutputStream fos = null;
            try {
                byte[] ivKey = EncryptUtil.HexToByte(password);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam(iv);
                fos = new FileOutputStream(plainTextFilePath);
                EncryptUtil.bigFileBlockEncrypt(false, key, (BlockCipher)new DESedeEngine(), param, new File(encryptFilePath), fos);
            }
            catch (PKIException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PKIException("Decrypt Failure", e);
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static void decryptFileByDES3(String encryptFilePath, ByteArrayOutputStream out, String password) throws PKIException {
        block6: {
            if (EncryptUtil.isHex(password) && 64 == password.length()) {
                try {
                    byte[] ivKey = EncryptUtil.HexToByte(password);
                    byte[] iv = new byte[8];
                    byte[] key = new byte[24];
                    System.arraycopy(ivKey, 0, iv, 0, 8);
                    System.arraycopy(ivKey, 8, key, 0, 24);
                    CBCParam param = new CBCParam(iv);
                    EncryptUtil.bigFileBlockEncrypt(false, key, (BlockCipher)new DESedeEngine(), param, new File(encryptFilePath), out);
                    break block6;
                }
                catch (PKIException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new PKIException("Decrypt Failure", e);
                }
            }
            throw new PKIException("the pwd is not hex string or length is not 64!");
        }
    }

    public static void encryptFileBySM4(String sourceFilePath, String encryptFilePath, String password) throws PKIException {
        try {
            byte[] plainTextData = FileHelper.read(sourceFilePath);
            byte[] encryptTextData = EncryptUtil.pbeWithSM4Encrypt(true, password, plainTextData);
            FileHelper.write(encryptFilePath, encryptTextData);
        }
        catch (IOException e) {
            throw new PKIException("EncryptFileBySM4 failure", e);
        }
    }

    public static byte[] encryptMessageBySM4(byte[] sourceData, String password) throws PKIException {
        return Base64.encode(EncryptUtil.pbeWithSM4Encrypt(true, password, sourceData));
    }

    public static byte[] decryptMessageBySM4(byte[] encryptData, String password) throws PKIException {
        return EncryptUtil.pbeWithSM4Encrypt(false, password, Base64.decode(encryptData));
    }

    public static byte[] encryptMessageBySM4(byte[] sourceData, byte[] iv, byte[] key) throws PKIException {
        return Base64.encode(EncryptUtil.doSM4WithCBC(true, iv, key, sourceData));
    }

    public static byte[] decryptMessageBySM4(byte[] encryptData, byte[] iv, byte[] key) throws PKIException {
        return EncryptUtil.doSM4WithCBC(false, iv, key, Base64.decode(encryptData));
    }

    public static void decryptFileBySM4(String encryptFilePath, String plainTextFilePath, String password) throws PKIException {
        try {
            byte[] encryptTextData = FileHelper.read(encryptFilePath);
            byte[] plainTextData = EncryptUtil.pbeWithSM4Encrypt(false, password, encryptTextData);
            FileHelper.write(plainTextFilePath, plainTextData);
        }
        catch (IOException e) {
            throw new PKIException("DecryptFileBySM4 failure", e);
        }
    }

    public static void decryptFileBySM4(String encryptFilePath, ByteArrayOutputStream out, String password) throws PKIException {
        if (out == null) {
            throw new IllegalArgumentException("plainTextByteArrayOutputStream");
        }
        try {
            byte[] encryptTextData = FileHelper.read(encryptFilePath);
            byte[] plainTextData = EncryptUtil.pbeWithSM4Encrypt(false, password, encryptTextData);
            out.write(plainTextData, 0, plainTextData.length);
        }
        catch (IOException e) {
            throw new PKIException("DecryptFileBySM4 failure", e);
        }
    }

    public static int decryptFileBySM4(String encryptedFilePath, byte[] outDecryptedBytes, String password) throws PKIException {
        if (outDecryptedBytes == null) {
            throw new PKIException("null not allowed for outPlainTextBytes");
        }
        byte[] decryptedBytes = null;
        byte[] encryptedBytes = null;
        try {
            encryptedBytes = FileHelper.read(encryptedFilePath);
            if (outDecryptedBytes.length < encryptedBytes.length) {
                throw new SecurityException("small length not allowed for outPlainTextBytes");
            }
            decryptedBytes = EncryptUtil.pbeWithSM4Encrypt(false, password, encryptedBytes);
            System.arraycopy(decryptedBytes, 0, outDecryptedBytes, 0, decryptedBytes.length);
            int n = decryptedBytes.length;
            return n;
        }
        catch (Exception e) {
            throw new PKIException("encrypt failure", e);
        }
        finally {
            decryptedBytes = null;
            encryptedBytes = null;
        }
    }

    private static void bigFileBlockEncrypt(boolean encryptFlag, byte[] key, BlockCipher engine, CBCParam param, File inFile, FileOutputStream out) throws Exception {
        FileInputStream fis = null;
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), param.getIv());
            cipher.init(encryptFlag, params);
            int readLen = 0;
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
            long readTotalLen = 0L;
            long fileLen = inFile.length();
            int processLen = 0;
            fis = new FileInputStream(inFile);
            while ((readLen = fis.read(buffer)) > 0) {
                if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                    processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    out.write(outBytes, 0, processLen);
                    continue;
                }
                int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                int len2 = cipher.doFinal(outBytes, len1);
                out.write(outBytes, 0, len1 + len2);
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static void bigFileBlockEncrypt(boolean encryptFlag, byte[] key, BlockCipher engine, CBCParam param, File inFile, ByteArrayOutputStream out) throws Exception {
        FileInputStream fis = null;
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), param.getIv());
            cipher.init(encryptFlag, params);
            int readLen = 0;
            byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
            byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
            long readTotalLen = 0L;
            long fileLen = inFile.length();
            int processLen = 0;
            fis = new FileInputStream(inFile);
            while ((readLen = fis.read(buffer)) > 0) {
                if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                    processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                    out.write(outBytes, 0, processLen);
                    continue;
                }
                int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                int len2 = cipher.doFinal(outBytes, len1);
                out.write(outBytes, 0, len1 + len2);
                break;
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static void bigFileBlockEncrypt(boolean encryptFlag, byte[] key, BlockCipher engine, CBCParam param, InputStream in, OutputStream out) throws Exception {
        PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(engine), new PKCS7Padding());
        ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), param.getIv());
        cipher.init(encryptFlag, params);
        int readLen = 0;
        byte[] buffer = new byte[FileAndBufferConfig.BIG_FILE_BUFFER];
        byte[] outBytes = new byte[FileAndBufferConfig.BIG_FILE_BUFFER + 100];
        long readTotalLen = 0L;
        long fileLen = in.available();
        int processLen = 0;
        while ((readLen = in.read(buffer)) > 0) {
            if (readLen == FileAndBufferConfig.BIG_FILE_BUFFER && (readTotalLen += (long)readLen) < fileLen) {
                processLen = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
                out.write(outBytes, 0, processLen);
                continue;
            }
            int len1 = cipher.processBytes(buffer, 0, readLen, outBytes, 0);
            int len2 = cipher.doFinal(outBytes, len1);
            out.write(outBytes, 0, len1 + len2);
            break;
        }
    }

    public static byte[] encrypt(Mechanism encryptAlg, Key key, byte[] sourceData, Session session) throws PKIException {
        try {
            byte[] encryptedBytes = session.encrypt(encryptAlg, key, sourceData);
            return Base64.encode(encryptedBytes);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt Failure", e);
        }
    }

    private static byte[] encryptForECITIC(Mechanism encryptAlg, Key key, byte[] sourceData, Session session) throws PKIException {
        try {
            byte[] encryptedBytes = session.encrypt(encryptAlg, key, sourceData);
            encryptedBytes = EncryptUtil.sm2FormatEncrypted64Bytes(encryptAlg, encryptedBytes);
            return Base64.encode(encryptedBytes);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt Failure", e);
        }
    }

    public static byte[] decrypt(Mechanism encryptAlg, Key key, byte[] encryptData, Session session) throws PKIException {
        try {
            return session.decrypt(encryptAlg, key, Base64.decode(encryptData));
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt Failure", e);
        }
    }

    public static void encrypt(Mechanism encryptAlg, Key key, String sourceFilePath, String encryptFilePath, Session session) throws PKIException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(sourceFilePath);
            File f = new File(encryptFilePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(f);
            session.encrypt(encryptAlg, key, fis, fos);
        }
        catch (Exception e) {
            throw new PKIException("encrypt failure", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public static void decrypt(Mechanism encryptAlg, Key key, String encryptFilePath, String plainTextFilePath, Session session) throws PKIException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(encryptFilePath);
            File f = new File(plainTextFilePath);
            if (!f.exists()) {
                f.createNewFile();
            }
            fos = new FileOutputStream(f);
            session.decrypt(encryptAlg, key, fis, fos);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Decrypt Failure", e);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e) {}
            }
            if (fis != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private static byte[] KDF(byte[] z) {
        byte[] ct = new byte[]{0, 0, 0, 1};
        SM3Digest sm3 = new SM3Digest();
        sm3.update(z, 0, z.length);
        sm3.update(ct, 0, ct.length);
        byte[] hash = new byte[32];
        sm3.doFinal(hash, 0);
        return hash;
    }

    private static byte[] pbeWithSM4Encrypt(boolean isEncrypted, String pass, byte[] data) throws PKIException {
        try {
            byte[] src = pass.getBytes("UTF8");
            byte[] hash = EncryptUtil.KDF(src);
            byte[] iv = new byte[16];
            System.arraycopy(hash, 0, iv, 0, 16);
            byte[] key = new byte[16];
            System.arraycopy(hash, 16, key, 0, 16);
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
            cipher.init(isEncrypted, params);
            int len = cipher.getOutputSize(data.length);
            byte[] tempData = new byte[len];
            int len1 = cipher.processBytes(data, 0, data.length, tempData, 0);
            int len2 = cipher.doFinal(tempData, len1);
            int total = len1 + len2;
            if (total < len) {
                byte[] removeZeroSourceData = new byte[total];
                System.arraycopy(tempData, 0, removeZeroSourceData, 0, total);
                return removeZeroSourceData;
            }
            return tempData;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt Failure", e);
        }
    }

    private static byte[] doSM4WithCBC(boolean isEncrypted, byte[] iv, byte[] key, byte[] data) throws PKIException {
        if (iv.length != 16 || key.length != 16) {
            throw new PKIException("iv.length and key.length must be 16 bytes!");
        }
        try {
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher(new CBCBlockCipher(new SM4Engine()), new PKCS7Padding());
            ParametersWithIV params = new ParametersWithIV(new KeyParameter(key), iv);
            cipher.init(isEncrypted, params);
            int len = cipher.getOutputSize(data.length);
            byte[] tempData = new byte[len];
            int len1 = cipher.processBytes(data, 0, data.length, tempData, 0);
            int len2 = cipher.doFinal(tempData, len1);
            int total = len1 + len2;
            if (total < len) {
                byte[] removeZeroSourceData = new byte[total];
                System.arraycopy(tempData, 0, removeZeroSourceData, 0, total);
                return removeZeroSourceData;
            }
            return tempData;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt/Decrypt Failure", e);
        }
    }

    public static byte[] encryptMessageByDES3(byte[] sourceData, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] encryptData = EncryptUtil.doWithPWD(sourceData, password, true);
                return Base64.encode(encryptData);
            }
            catch (Exception e) {
                throw new PKIException("Encrypt message failure", e);
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static byte[] decryptMessageByDES3(byte[] base64EncryptedBytes, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] decryptedData = EncryptUtil.doWithPWD(Base64.decode(base64EncryptedBytes), password, false);
                return decryptedData;
            }
            catch (Exception e) {
                throw new PKIException("Decrypt message failure", e);
            }
        }
        throw new PKIException("the pwd is not hex string or length is not 64!");
    }

    public static byte[] encryptMessageByDES3(byte[] sourceData, byte[] des3iv, byte[] des3key) throws PKIException {
        try {
            byte[] encryptData = EncryptUtil.doDES3WithCBC(sourceData, des3iv, des3key, true);
            return Base64.encode(encryptData);
        }
        catch (Exception e) {
            throw new PKIException("Encrypt message failure", e);
        }
    }

    public static byte[] decryptMessageByDES3(byte[] base64EncryptedBytes, byte[] des3iv, byte[] des3key) throws PKIException {
        try {
            byte[] decryptedData = EncryptUtil.doDES3WithCBC(Base64.decode(base64EncryptedBytes), des3iv, des3key, false);
            return decryptedData;
        }
        catch (Exception e) {
            throw new PKIException("Decrypt message failure", e);
        }
    }

    public static void encryptFileByDES3(FileInputStream plainFileInputStream, FileOutputStream out, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] ivKey = EncryptUtil.HexToByte(password);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam(iv);
                EncryptUtil.bigFileBlockEncrypt(true, key, (BlockCipher)new DESedeEngine(), param, plainFileInputStream, (OutputStream)out);
            }
            catch (Exception e) {
                throw new PKIException("Encrypt file failure", e);
            }
        } else {
            throw new PKIException("the pwd is not hex string or length is not 64!");
        }
    }

    public static void decryptFileByDES3(FileInputStream encryptedFileInputStream, FileOutputStream out, String password) throws PKIException {
        if (EncryptUtil.isHex(password) && password.length() == 64) {
            try {
                byte[] ivKey = EncryptUtil.HexToByte(password);
                byte[] iv = new byte[8];
                byte[] key = new byte[24];
                System.arraycopy(ivKey, 0, iv, 0, 8);
                System.arraycopy(ivKey, 8, key, 0, 24);
                CBCParam param = new CBCParam(iv);
                EncryptUtil.bigFileBlockEncrypt(false, key, (BlockCipher)new DESedeEngine(), param, encryptedFileInputStream, (OutputStream)out);
            }
            catch (Exception e) {
                throw new PKIException("Decrypt file failure", e);
            }
        } else {
            throw new PKIException("the pwd is not hex string or length is not 64!");
        }
    }

    public static void encryptFileByDES3(FileInputStream plainFileInputStream, FileOutputStream out, byte[] des3iv, byte[] des3key) throws PKIException {
        try {
            CBCParam param = new CBCParam(des3iv);
            EncryptUtil.bigFileBlockEncrypt(true, des3key, (BlockCipher)new DESedeEngine(), param, plainFileInputStream, (OutputStream)out);
        }
        catch (Exception e) {
            throw new PKIException("Encrypt file failure", e);
        }
    }

    public static void decryptFileByDES3(FileInputStream encryptedFileInputStream, FileOutputStream out, byte[] des3iv, byte[] des3key) throws PKIException {
        try {
            CBCParam param = new CBCParam(des3iv);
            EncryptUtil.bigFileBlockEncrypt(false, des3key, (BlockCipher)new DESedeEngine(), param, encryptedFileInputStream, (OutputStream)out);
        }
        catch (Exception e) {
            throw new PKIException("Encrypt file failure", e);
        }
    }

    public static void encryptFileBySM4(FileInputStream plainFileInputStream, FileOutputStream out, String password) throws PKIException {
        byte[] plainTextData = null;
        byte[] encryptTextData = null;
        try {
            int dataLen = plainFileInputStream.available();
            plainTextData = new byte[dataLen];
            plainFileInputStream.read(plainTextData);
            encryptTextData = EncryptUtil.pbeWithSM4Encrypt(true, password, plainTextData);
            out.write(encryptTextData);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new PKIException("Encrypt file failure", e);
        }
        catch (IOException e) {
            throw new PKIException("Encrypt file failure", e);
        }
        catch (Exception e) {
            throw new PKIException("Encrypt file failure", e);
        }
    }

    public static void decryptFileBySM4(FileInputStream encryptedFileInputStream, FileOutputStream out, String password) throws PKIException {
        byte[] decryptedData = null;
        byte[] encryptedData = null;
        try {
            int dataLen = encryptedFileInputStream.available();
            encryptedData = new byte[dataLen];
            encryptedFileInputStream.read(encryptedData);
            decryptedData = EncryptUtil.pbeWithSM4Encrypt(false, password, encryptedData);
            out.write(decryptedData);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new PKIException("Decrypt file failure", e);
        }
        catch (IOException e) {
            throw new PKIException("Decrypt file failure", e);
        }
        catch (Exception e) {
            throw new PKIException("Decrypt file failure", e);
        }
    }

    public static void encryptFileBySM4(FileInputStream plainFileInputStream, FileOutputStream out, byte[] sm4iv, byte[] sm4key) throws PKIException {
        byte[] plainTextData = null;
        byte[] encryptTextData = null;
        try {
            int dataLen = plainFileInputStream.available();
            plainTextData = new byte[dataLen];
            plainFileInputStream.read(plainTextData);
            encryptTextData = EncryptUtil.doSM4WithCBC(true, sm4iv, sm4key, plainTextData);
            out.write(encryptTextData);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new PKIException("Encrypt file failure", e);
        }
        catch (IOException e) {
            throw new PKIException("Encrypt file failure", e);
        }
        catch (Exception e) {
            throw new PKIException("Encrypt file failure", e);
        }
    }

    public static void decryptFileBySM4(FileInputStream encryptedFileInputStream, FileOutputStream out, byte[] sm4iv, byte[] sm4key) throws PKIException {
        byte[] decryptedData = null;
        byte[] encryptedData = null;
        try {
            int dataLen = encryptedFileInputStream.available();
            encryptedData = new byte[dataLen];
            encryptedFileInputStream.read(encryptedData);
            decryptedData = EncryptUtil.doSM4WithCBC(false, sm4iv, sm4key, encryptedData);
            out.write(decryptedData);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw new PKIException("Encrypt file failure", e);
        }
        catch (IOException e) {
            throw new PKIException("Encrypt file failure", e);
        }
        catch (Exception e) {
            throw new PKIException("Encrypt file failure", e);
        }
    }

    public static byte[] encryptMessage(Mechanism encryptAlg, PublicKey publicKey, byte[] sourceData, Session session) throws PKIException {
        try {
            byte[] encryptedBytes = session.encrypt(encryptAlg, publicKey, sourceData);
            encryptedBytes = EncryptUtil.sm2FormatEncrypted64Bytes(encryptAlg, encryptedBytes);
            return Base64.encode(encryptedBytes);
        }
        catch (Exception e) {
            throw new PKIException("Encrypt message failure", e);
        }
    }

    public static byte[] decryptMessage(Mechanism encryptAlg, Key key, byte[] base64EncryptedBytes, Session session) throws PKIException {
        try {
            return session.decrypt(encryptAlg, key, Base64.decode(base64EncryptedBytes));
        }
        catch (Exception e) {
            throw new PKIException("Decrypt message failure", e);
        }
    }

    public static void encrypt(Mechanism mechanism, Key key, FileInputStream plainFileInputStream, FileOutputStream out, Session session) throws PKIException {
        try {
            session.encrypt(mechanism, key, plainFileInputStream, out);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt  failure", e);
        }
    }

    public static void decrypt(Mechanism encryptAlg, Key key, FileInputStream encryptFileInputStream, FileOutputStream out, Session session) throws PKIException {
        try {
            session.decrypt(encryptAlg, key, encryptFileInputStream, out);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Decrypt  failure", e);
        }
    }

    public static void encryptFileBySM2(FileInputStream plainFileInputStream, FileOutputStream out, X509Cert sm2cert, Session session) throws PKIException {
        try {
            EncryptUtil.encryptFileBySM2(plainFileInputStream, out, sm2cert.getPublicKey(), session);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt file failure", e);
        }
    }

    public static void encryptFileBySM2(FileInputStream plainFileInputStream, FileOutputStream out, PublicKey sm2pubKey, Session session) throws PKIException {
        try {
            byte[] plainData = new byte[plainFileInputStream.available()];
            plainFileInputStream.read(plainData);
            byte[] encryptedData = EncryptUtil.encryptMessageBySM2(plainData, sm2pubKey, session);
            out.write(encryptedData);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Encrypt file failure", e);
        }
    }

    public static void decryptFileBySM2(FileInputStream encryptedFileInputStream, FileOutputStream out, PrivateKey sm2priKey, Session session) throws PKIException {
        try {
            byte[] encryptedData = new byte[encryptedFileInputStream.available()];
            encryptedFileInputStream.read(encryptedData);
            byte[] decryptedData = EncryptUtil.decryptMessageBySM2(encryptedData, sm2priKey, session);
            out.write(decryptedData);
        }
        catch (PKIException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PKIException("Decrypt file failure", e);
        }
    }

    private static final byte[] sm2FormatEncrypted64Bytes(Mechanism mechanism, byte[] encryptedBytes) {
        if (mechanism != null && "SM2".equals(mechanism.getMechanismType())) {
            encryptedBytes = SM2OutputFormat.sm2FormatEncryptedRAWBytes(encryptedBytes);
        }
        return encryptedBytes;
    }
}

