/*
 * Decompiled with CFR 0.152.
 */
package com.huifu.adapay.notify.mqtt;

import com.huifu.adapay.AdaPay;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;

public class ConnectionOptionWrapper {
    private MqttConnectOptions mqttConnectOptions;

    public ConnectionOptionWrapper(Map<String, String> inputTokenData) {
        ConcurrentHashMap<String, String> tokenData = new ConcurrentHashMap<String, String>(1);
        if (inputTokenData != null) {
            tokenData.putAll(inputTokenData);
        }
        this.mqttConnectOptions = new MqttConnectOptions();
        this.mqttConnectOptions.setUserName("Token|" + AdaPay.getMqttAccessKey() + "|" + AdaPay.getMqttInstanceId());
        StringBuilder builder = new StringBuilder();
        for (Map.Entry entry : tokenData.entrySet()) {
            builder.append((String)entry.getKey()).append("|").append((String)entry.getValue()).append("|");
        }
        if (builder.length() > 0) {
            builder.setLength(builder.length() - 1);
        }
        this.mqttConnectOptions.setPassword(builder.toString().toCharArray());
        this.mqttConnectOptions.setCleanSession(false);
        this.mqttConnectOptions.setKeepAliveInterval(90);
        this.mqttConnectOptions.setAutomaticReconnect(true);
        this.mqttConnectOptions.setMqttVersion(4);
        this.mqttConnectOptions.setConnectionTimeout(5000);
    }

    public MqttConnectOptions getMqttConnectOptions() {
        return this.mqttConnectOptions;
    }
}

