/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow;

import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import com.timevale.tgtext.bouncycastle.pqc.crypto.rainbow.util.RainbowUtil;
import com.timevale.tgtext.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class Layer {
    private int vi;
    private int viNext;
    private int oi;
    private short[][][] coeff_alpha;
    private short[][][] coeff_beta;
    private short[][] coeff_gamma;
    private short[] coeff_eta;

    public Layer(byte vi, byte viNext, short[][][] coeffAlpha, short[][][] coeffBeta, short[][] coeffGamma, short[] coeffEta) {
        this.vi = vi & 0xFF;
        this.viNext = viNext & 0xFF;
        this.oi = this.viNext - this.vi;
        this.coeff_alpha = coeffAlpha;
        this.coeff_beta = coeffBeta;
        this.coeff_gamma = coeffGamma;
        this.coeff_eta = coeffEta;
    }

    public Layer(int vi, int viNext, SecureRandom sr) {
        int j2;
        int i2;
        int k2;
        this.vi = vi;
        this.viNext = viNext;
        this.oi = viNext - vi;
        this.coeff_alpha = new short[this.oi][this.oi][this.vi];
        this.coeff_beta = new short[this.oi][this.vi][this.vi];
        this.coeff_gamma = new short[this.oi][this.viNext];
        this.coeff_eta = new short[this.oi];
        int numOfPoly = this.oi;
        for (k2 = 0; k2 < numOfPoly; ++k2) {
            for (i2 = 0; i2 < this.oi; ++i2) {
                for (j2 = 0; j2 < this.vi; ++j2) {
                    this.coeff_alpha[k2][i2][j2] = (short)(sr.nextInt() & 0xFF);
                }
            }
        }
        for (k2 = 0; k2 < numOfPoly; ++k2) {
            for (i2 = 0; i2 < this.vi; ++i2) {
                for (j2 = 0; j2 < this.vi; ++j2) {
                    this.coeff_beta[k2][i2][j2] = (short)(sr.nextInt() & 0xFF);
                }
            }
        }
        for (k2 = 0; k2 < numOfPoly; ++k2) {
            for (i2 = 0; i2 < this.viNext; ++i2) {
                this.coeff_gamma[k2][i2] = (short)(sr.nextInt() & 0xFF);
            }
        }
        for (k2 = 0; k2 < numOfPoly; ++k2) {
            this.coeff_eta[k2] = (short)(sr.nextInt() & 0xFF);
        }
    }

    public short[][] plugInVinegars(short[] x2) {
        short tmpMult;
        int j2;
        int i2;
        int k2;
        short[][] coeff = new short[this.oi][this.oi + 1];
        short[] sum = new short[this.oi];
        for (k2 = 0; k2 < this.oi; ++k2) {
            for (i2 = 0; i2 < this.vi; ++i2) {
                for (j2 = 0; j2 < this.vi; ++j2) {
                    tmpMult = GF2Field.multElem(this.coeff_beta[k2][i2][j2], x2[i2]);
                    tmpMult = GF2Field.multElem(tmpMult, x2[j2]);
                    sum[k2] = GF2Field.addElem(sum[k2], tmpMult);
                }
            }
        }
        for (k2 = 0; k2 < this.oi; ++k2) {
            for (i2 = 0; i2 < this.oi; ++i2) {
                for (j2 = 0; j2 < this.vi; ++j2) {
                    tmpMult = GF2Field.multElem(this.coeff_alpha[k2][i2][j2], x2[j2]);
                    coeff[k2][i2] = GF2Field.addElem(coeff[k2][i2], tmpMult);
                }
            }
        }
        for (k2 = 0; k2 < this.oi; ++k2) {
            for (i2 = 0; i2 < this.vi; ++i2) {
                tmpMult = GF2Field.multElem(this.coeff_gamma[k2][i2], x2[i2]);
                sum[k2] = GF2Field.addElem(sum[k2], tmpMult);
            }
        }
        for (k2 = 0; k2 < this.oi; ++k2) {
            for (i2 = this.vi; i2 < this.viNext; ++i2) {
                coeff[k2][i2 - this.vi] = GF2Field.addElem(this.coeff_gamma[k2][i2], coeff[k2][i2 - this.vi]);
            }
        }
        for (k2 = 0; k2 < this.oi; ++k2) {
            sum[k2] = GF2Field.addElem(sum[k2], this.coeff_eta[k2]);
        }
        for (k2 = 0; k2 < this.oi; ++k2) {
            coeff[k2][this.oi] = sum[k2];
        }
        return coeff;
    }

    public int getVi() {
        return this.vi;
    }

    public int getViNext() {
        return this.viNext;
    }

    public int getOi() {
        return this.oi;
    }

    public short[][][] getCoeffAlpha() {
        return this.coeff_alpha;
    }

    public short[][][] getCoeffBeta() {
        return this.coeff_beta;
    }

    public short[][] getCoeffGamma() {
        return this.coeff_gamma;
    }

    public short[] getCoeffEta() {
        return this.coeff_eta;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Layer)) {
            return false;
        }
        Layer otherLayer = (Layer)other;
        return this.vi == otherLayer.getVi() && this.viNext == otherLayer.getViNext() && this.oi == otherLayer.getOi() && RainbowUtil.equals(this.coeff_alpha, otherLayer.getCoeffAlpha()) && RainbowUtil.equals(this.coeff_beta, otherLayer.getCoeffBeta()) && RainbowUtil.equals(this.coeff_gamma, otherLayer.getCoeffGamma()) && RainbowUtil.equals(this.coeff_eta, otherLayer.getCoeffEta());
    }

    public int hashCode() {
        int hash = this.vi;
        hash = hash * 37 + this.viNext;
        hash = hash * 37 + this.oi;
        hash = hash * 37 + Arrays.hashCode(this.coeff_alpha);
        hash = hash * 37 + Arrays.hashCode(this.coeff_beta);
        hash = hash * 37 + Arrays.hashCode(this.coeff_gamma);
        hash = hash * 37 + Arrays.hashCode(this.coeff_eta);
        return hash;
    }
}

