/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.crypto.params;

import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionKeyParameters;
import com.timevale.tgtext.bouncycastle.crypto.params.NTRUEncryptionParameters;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.DenseTernaryPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.IntegerPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.Polynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.ProductFormPolynomial;
import com.timevale.tgtext.bouncycastle.math.ntru.polynomial.SparseTernaryPolynomial;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NTRUEncryptionPrivateKeyParameters
extends NTRUEncryptionKeyParameters {
    public Polynomial t;
    public IntegerPolynomial fp;
    public IntegerPolynomial h;

    public NTRUEncryptionPrivateKeyParameters(IntegerPolynomial h2, Polynomial t2, IntegerPolynomial fp2, NTRUEncryptionParameters params) {
        super(true, params);
        this.h = h2;
        this.t = t2;
        this.fp = fp2;
    }

    public NTRUEncryptionPrivateKeyParameters(byte[] b2, NTRUEncryptionParameters params) throws IOException {
        this(new ByteArrayInputStream(b2), params);
    }

    public NTRUEncryptionPrivateKeyParameters(InputStream is, NTRUEncryptionParameters params) throws IOException {
        super(true, params);
        Polynomial polynomial;
        NTRUEncryptionPrivateKeyParameters nTRUEncryptionPrivateKeyParameters;
        if (params.polyType == 1) {
            int N = params.N;
            int df1 = params.df1;
            int df2 = params.df2;
            int df3Ones = params.df3;
            int df3NegOnes = params.fastFp ? params.df3 : params.df3 - 1;
            this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
            nTRUEncryptionPrivateKeyParameters = this;
            polynomial = ProductFormPolynomial.fromBinary(is, N, df1, df2, df3Ones, df3NegOnes);
        } else {
            this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
            IntegerPolynomial fInt = IntegerPolynomial.fromBinary3Tight(is, params.N);
            nTRUEncryptionPrivateKeyParameters = this;
            polynomial = params.sparse ? new SparseTernaryPolynomial(fInt) : new DenseTernaryPolynomial(fInt);
        }
        nTRUEncryptionPrivateKeyParameters.t = polynomial;
        this.init();
    }

    private void init() {
        if (this.params.fastFp) {
            this.fp = new IntegerPolynomial(this.params.N);
            this.fp.coeffs[0] = 1;
            return;
        }
        this.fp = this.t.toIntegerPolynomial().invertF3();
    }

    public byte[] getEncoded() {
        byte[] hBytes = this.h.toBinary(this.params.q);
        byte[] tBytes = this.t instanceof ProductFormPolynomial ? ((ProductFormPolynomial)this.t).toBinary() : this.t.toIntegerPolynomial().toBinary3Tight();
        byte[] res = new byte[hBytes.length + tBytes.length];
        System.arraycopy(hBytes, 0, res, 0, hBytes.length);
        System.arraycopy(tBytes, 0, res, hBytes.length, tBytes.length);
        return res;
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int result = 31 + (this.params == null ? 0 : this.params.hashCode());
        result = result * 31 + (this.t == null ? 0 : this.t.hashCode());
        result = result * 31 + (this.h == null ? 0 : this.h.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTRUEncryptionPrivateKeyParameters)) {
            return false;
        }
        NTRUEncryptionPrivateKeyParameters other = (NTRUEncryptionPrivateKeyParameters)obj;
        if (this.params == null ? other.params != null : !this.params.equals(other.params)) {
            return false;
        }
        if (this.t == null ? other.t != null : !this.t.equals(other.t)) {
            return false;
        }
        return this.h.equals(other.h);
    }
}

