/*
 * Decompiled with CFR 0.152.
 */
package com.timevale.tgtext.bouncycastle.pqc.crypto;

import com.timevale.tgtext.bouncycastle.crypto.CipherParameters;
import com.timevale.tgtext.bouncycastle.crypto.Digest;
import com.timevale.tgtext.bouncycastle.crypto.Signer;
import com.timevale.tgtext.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.timevale.tgtext.bouncycastle.crypto.params.ParametersWithRandom;
import com.timevale.tgtext.bouncycastle.pqc.crypto.MessageSigner;

public class DigestingMessageSigner
implements Signer {
    private final Digest messDigest;
    private final MessageSigner messSigner;
    private boolean forSigning;

    public DigestingMessageSigner(MessageSigner messSigner, Digest messDigest) {
        this.messSigner = messSigner;
        this.messDigest = messDigest;
    }

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        this.forSigning = forSigning;
        AsymmetricKeyParameter k2 = param instanceof ParametersWithRandom ? (AsymmetricKeyParameter)((ParametersWithRandom)param).getParameters() : (AsymmetricKeyParameter)param;
        if (forSigning && !k2.isPrivate()) {
            throw new IllegalArgumentException("Signing Requires Private Key.");
        }
        if (!forSigning && k2.isPrivate()) {
            throw new IllegalArgumentException("Verification Requires Public Key.");
        }
        this.reset();
        this.messSigner.init(forSigning, param);
    }

    @Override
    public byte[] generateSignature() {
        if (!this.forSigning) {
            throw new IllegalStateException("RainbowDigestSigner not initialised for signature generation.");
        }
        byte[] hash = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(hash, 0);
        return this.messSigner.generateSignature(hash);
    }

    public boolean verify(byte[] signature) {
        if (this.forSigning) {
            throw new IllegalStateException("RainbowDigestSigner not initialised for verification");
        }
        byte[] hash = new byte[this.messDigest.getDigestSize()];
        this.messDigest.doFinal(hash, 0);
        return this.messSigner.verifySignature(hash, signature);
    }

    @Override
    public void update(byte b2) {
        this.messDigest.update(b2);
    }

    @Override
    public void update(byte[] in, int off, int len) {
        this.messDigest.update(in, off, len);
    }

    @Override
    public void reset() {
        this.messDigest.reset();
    }

    @Override
    public boolean verifySignature(byte[] signature) {
        return this.verify(signature);
    }
}

