/*
 * Decompiled with CFR 0.152.
 */
package cfca.sadk.org.bouncycastle.crypto.tls;

import cfca.sadk.org.bouncycastle.crypto.modes.AEADBlockCipher;
import cfca.sadk.org.bouncycastle.crypto.params.AEADParameters;
import cfca.sadk.org.bouncycastle.crypto.params.KeyParameter;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsCipher;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsContext;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsFatalAlert;
import cfca.sadk.org.bouncycastle.crypto.tls.TlsUtils;
import cfca.sadk.org.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsAEADCipher
implements TlsCipher {
    protected TlsContext context;
    protected int macSize;
    protected int nonce_explicit_length;
    protected AEADBlockCipher encryptCipher;
    protected AEADBlockCipher decryptCipher;
    protected byte[] encryptImplicitNonce;
    protected byte[] decryptImplicitNonce;

    public TlsAEADCipher(TlsContext context, AEADBlockCipher clientWriteCipher, AEADBlockCipher serverWriteCipher, int cipherKeySize, int macSize) throws IOException {
        KeyParameter decryptKey;
        KeyParameter encryptKey;
        if (!TlsUtils.isTLSv12(context)) {
            throw new TlsFatalAlert(80);
        }
        this.context = context;
        this.macSize = macSize;
        this.nonce_explicit_length = 8;
        int fixed_iv_length = 4;
        int key_block_size = 2 * cipherKeySize + 2 * fixed_iv_length;
        byte[] key_block = TlsUtils.calculateKeyBlock(context, key_block_size);
        int offset = 0;
        KeyParameter client_write_key = new KeyParameter(key_block, offset, cipherKeySize);
        KeyParameter server_write_key = new KeyParameter(key_block, offset += cipherKeySize, cipherKeySize);
        byte[] client_write_IV = Arrays.copyOfRange(key_block, offset += cipherKeySize, offset + fixed_iv_length);
        byte[] server_write_IV = Arrays.copyOfRange(key_block, offset += fixed_iv_length, offset + fixed_iv_length);
        if ((offset += fixed_iv_length) != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (context.isServer()) {
            this.encryptCipher = serverWriteCipher;
            this.decryptCipher = clientWriteCipher;
            this.encryptImplicitNonce = server_write_IV;
            this.decryptImplicitNonce = client_write_IV;
            encryptKey = server_write_key;
            decryptKey = client_write_key;
        } else {
            this.encryptCipher = clientWriteCipher;
            this.decryptCipher = serverWriteCipher;
            this.encryptImplicitNonce = client_write_IV;
            this.decryptImplicitNonce = server_write_IV;
            encryptKey = client_write_key;
            decryptKey = server_write_key;
        }
        byte[] dummyNonce = new byte[fixed_iv_length + this.nonce_explicit_length];
        this.encryptCipher.init(true, new AEADParameters(encryptKey, 8 * macSize, dummyNonce));
        this.decryptCipher.init(false, new AEADParameters(decryptKey, 8 * macSize, dummyNonce));
    }

    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.macSize - this.nonce_explicit_length;
    }

    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        byte[] nonce = new byte[this.encryptImplicitNonce.length + this.nonce_explicit_length];
        System.arraycopy(this.encryptImplicitNonce, 0, nonce, 0, this.encryptImplicitNonce.length);
        TlsUtils.writeUint64(seqNo, nonce, this.encryptImplicitNonce.length);
        int plaintextOffset = offset;
        int plaintextLength = len;
        int ciphertextLength = this.encryptCipher.getOutputSize(plaintextLength);
        byte[] output = new byte[this.nonce_explicit_length + ciphertextLength];
        System.arraycopy(nonce, this.encryptImplicitNonce.length, output, 0, this.nonce_explicit_length);
        int outputPos = this.nonce_explicit_length;
        byte[] additionalData = this.getAdditionalData(seqNo, type, plaintextLength);
        AEADParameters parameters = new AEADParameters(null, 8 * this.macSize, nonce, additionalData);
        try {
            this.encryptCipher.init(true, parameters);
            outputPos += this.encryptCipher.processBytes(plaintext, plaintextOffset, plaintextLength, output, outputPos);
            outputPos += this.encryptCipher.doFinal(output, outputPos);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(80);
        }
        if (outputPos != output.length) {
            throw new TlsFatalAlert(80);
        }
        return output;
    }

    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        if (this.getPlaintextLimit(len) < 0) {
            throw new TlsFatalAlert(50);
        }
        byte[] nonce = new byte[this.decryptImplicitNonce.length + this.nonce_explicit_length];
        System.arraycopy(this.decryptImplicitNonce, 0, nonce, 0, this.decryptImplicitNonce.length);
        System.arraycopy(ciphertext, offset, nonce, this.decryptImplicitNonce.length, this.nonce_explicit_length);
        int ciphertextOffset = offset + this.nonce_explicit_length;
        int ciphertextLength = len - this.nonce_explicit_length;
        int plaintextLength = this.decryptCipher.getOutputSize(ciphertextLength);
        byte[] output = new byte[plaintextLength];
        int outputPos = 0;
        byte[] additionalData = this.getAdditionalData(seqNo, type, plaintextLength);
        AEADParameters parameters = new AEADParameters(null, 8 * this.macSize, nonce, additionalData);
        try {
            this.decryptCipher.init(false, parameters);
            outputPos += this.decryptCipher.processBytes(ciphertext, ciphertextOffset, ciphertextLength, output, outputPos);
            outputPos += this.decryptCipher.doFinal(output, outputPos);
        }
        catch (Exception e) {
            throw new TlsFatalAlert(20);
        }
        if (outputPos != output.length) {
            throw new TlsFatalAlert(80);
        }
        return output;
    }

    protected byte[] getAdditionalData(long seqNo, short type, int len) throws IOException {
        byte[] additional_data = new byte[13];
        TlsUtils.writeUint64(seqNo, additional_data, 0);
        TlsUtils.writeUint8(type, additional_data, 8);
        TlsUtils.writeVersion(this.context.getServerVersion(), additional_data, 9);
        TlsUtils.writeUint16(len, additional_data, 11);
        return additional_data;
    }
}

